/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.AirshipEntityRenderer;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;

public class CargoAirshipEntityRenderer<T extends AirshipEntity>
extends AirshipEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/cargo_airship.obj");
    private final ResourceLocation texture = Main.locate("textures/entity/cargo_airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model(this).add(new AircraftEntityRenderer.Object(this, id, "frame")).add(new AircraftEntityRenderer.Object(this, id, "storage")).add(new AircraftEntityRenderer.Object(this, id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<ItemStack> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            if (slot.m_41619_() || !(slot.m_41720_() instanceof BannerItem)) continue;
            List<Pair<BannerPattern, DyeColor>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "banner_" + i++);
            CargoAirshipEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(this, id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        DyeColor color;
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        ItemStack stack = entity.getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        Item patt3052$temp = stack.m_41720_();
        if (patt3052$temp instanceof DyeItem) {
            DyeItem item = (DyeItem)patt3052$temp;
            color = item.m_41089_();
        } else {
            color = DyeColor.WHITE;
        }
        float r = color.m_41068_()[0];
        float g = color.m_41068_()[1];
        float b = color.m_41068_()[2];
        if (entity.isWithinParticleRange() && Config.getInstance().enableAnimatedSails) {
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.f_19853_.m_46467_() % 24000L) + tickDelta;
            CargoAirshipEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, r, g, b, 1.0f);
        } else {
            Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "sails");
            CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, r, g, b, 1.0f);
        }
    })).add(new AircraftEntityRenderer.Object(this, id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, -0.125, 0.78125);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-entity.pressingInterpolatedX.getSmooth(tickDelta) * 20.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
        matrixStack.m_85837_(0.0, 0.125, -0.90625);
    })).add(new AircraftEntityRenderer.Object(this, id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, 0.1875, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.m_85837_(0.0, -0.1875, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "propeller");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(this, id, "small_propeller_right").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(-1.15625, 2.34375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.m_85837_(1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "small_propeller_right");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(this, id, "small_propeller_left").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(1.15625, 2.34375, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.m_85837_(-1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        Mesh mesh = CargoAirshipEntityRenderer.getFaces(id, "small_propeller_left");
        CargoAirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public CargoAirshipEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
    }

    @Override
    public ResourceLocation getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.2f, 0.0f);
    }
}

