/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.exception.DoNotHandleException;
import com.bawnorton.neruina.thread.ConditionalRunnable;
import com.bawnorton.neruina.version.Version;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class NeruinaTickHandler {
    private static final Set<BlockEntity> ERRORED_BLOCK_ENTITIES = new HashSet<BlockEntity>();
    private static final Set<Entity> ERRORED_ENTITIES = new HashSet<Entity>();
    private static final Set<ItemStack> ERRORED_ITEM_STACKS = new HashSet<ItemStack>();
    private static final Set<ImmutablePair<BlockPos, BlockState>> ERRORED_BLOCK_STATES = new HashSet<ImmutablePair<BlockPos, BlockState>>();
    private static MinecraftServer server;

    public static void setServer(MinecraftServer server) {
        NeruinaTickHandler.server = server;
    }

    public static void safelyTickItemStack$notTheCauseOfTickLag(ItemStack instance, Level world, Entity entity, int slot, boolean selected, Operation<Void> original) {
        block3: {
            try {
                if (NeruinaTickHandler.isErrored(instance)) {
                    return;
                }
                original.call(new Object[]{instance, world, entity, slot, selected});
            }
            catch (Throwable e) {
                String message = Version.translatableText("neruina.ticking.item_stack", instance.m_41720_().m_41466_().getString(), slot).getString();
                Neruina.LOGGER.warn((world.f_46443_ ? "Client: " : "Server: ") + message, e);
                NeruinaTickHandler.addErrored(instance);
                if (!world.f_46443_ || !(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                player.m_5661_(Version.textOf(message), false);
            }
        }
    }

    public static void safelyTickPlayer$notTheCauseOfTickLag(ServerPlayer instance, Operation<Void> original) {
        try {
            original.call(new Object[]{instance});
        }
        catch (Throwable e) {
            NeruinaTickHandler.handleTickingPlayer(instance, e);
        }
    }

    public static void safelyTickBlockState$notTheCauseOfTickLag(BlockState instance, ServerLevel world, BlockPos pos, Object random, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(pos, instance)) {
                return;
            }
            original.call(new Object[]{instance, world, pos, random});
        }
        catch (Throwable e) {
            String message = Version.translatableText("neruina.ticking.block_state", instance.m_60734_().m_49954_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).getString();
            Neruina.LOGGER.warn("Server: " + message, e);
            NeruinaTickHandler.addErrored(pos, instance);
            NeruinaTickHandler.messagePlayers(message);
        }
    }

    public static void safelyTickBlockEntity$notTheCauseOfTickLag(BlockEntityTicker<? extends BlockEntity> instance, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity, Operation<Void> original) {
        block4: {
            try {
                if (NeruinaTickHandler.isErrored(blockEntity)) {
                    if (world.f_46443_) {
                        return;
                    }
                    LevelChunk chunk = world.m_46745_(pos);
                    chunk.m_156412_(pos);
                    return;
                }
                original.call(new Object[]{instance, world, pos, state, blockEntity});
            }
            catch (Throwable e) {
                String message = Version.translatableText("neruina.ticking.block_entity", state.m_60734_().m_49954_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).getString();
                Neruina.LOGGER.warn((world.f_46443_ ? "Client: " : "Server: ") + message, e);
                NeruinaTickHandler.addErrored(blockEntity);
                if (world.m_5776_()) break block4;
                NeruinaTickHandler.messagePlayers(message);
            }
        }
    }

    public static <T extends Entity> void safelyTickEntities$notTheCauseOfTickLag(Consumer<T> instance, T entity, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(entity)) {
                NeruinaTickHandler.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{instance, entity});
        }
        catch (DoNotHandleException e) {
            throw e;
        }
        catch (Throwable e) {
            NeruinaTickHandler.handleEntityTicking(entity, e);
        }
    }

    public static <T extends Entity> void safelyTickEntities$notTheCauseOfTickLag(Consumer<T> consumer, T entity, Level world, Object random, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(entity)) {
                NeruinaTickHandler.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{consumer, entity, world, random});
        }
        catch (DoNotHandleException e) {
            throw e;
        }
        catch (Throwable e) {
            NeruinaTickHandler.handleEntityTicking(entity, e);
        }
    }

    private static void handleErroredEntity(Entity entity) {
        try {
            if (entity instanceof Player) {
                return;
            }
            if (entity.m_20193_().m_5776_()) {
                return;
            }
            entity.m_6074_();
            entity.m_142687_(Entity.RemovalReason.KILLED);
            entity.m_6075_();
            NeruinaTickHandler.removeErrored(entity);
        }
        catch (Throwable e) {
            throw new DoNotHandleException(e);
        }
    }

    private static void handleEntityTicking(Entity entity, Throwable e) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NeruinaTickHandler.handleTickingPlayer(player, e);
            return;
        }
        if (entity instanceof Player) {
            throw new DoNotHandleException(e);
        }
        Vec3 pos = entity.m_20182_();
        String message = Version.translatableText("neruina.ticking.entity", entity.m_7755_().getString(), Math.floor(pos.m_7096_()), Math.floor(pos.m_7098_()), Math.floor(pos.m_7094_())).getString();
        Neruina.LOGGER.warn((entity.m_20193_().f_46443_ ? "Client: " : "Server: ") + message, e);
        NeruinaTickHandler.addErrored(entity);
        if (!entity.m_20193_().m_5776_()) {
            NeruinaTickHandler.messagePlayers(message);
        }
    }

    private static void handleTickingPlayer(ServerPlayer player, Throwable e) {
        String message = Version.translatableText("neruina.ticking.player", player.m_7755_().getString()).getString();
        Neruina.LOGGER.warn(message, e);
        if (!player.m_20193_().m_5776_()) {
            if (!server.m_6982_()) {
                throw new DoNotHandleException(e);
            }
            NeruinaTickHandler.messagePlayers(message);
            player.f_8906_.m_9942_(Version.textOf(Version.translatableText("neruina.kick.message", new Object[0]).getString()));
        }
    }

    private static void messagePlayers(Component message) {
        PlayerList playerManager = server.m_6846_();
        ConditionalRunnable.create(() -> playerManager.m_11314_().forEach(player -> player.m_5661_(message, false)), () -> playerManager.m_11309_() >= 1);
    }

    private static void messagePlayers(String message) {
        NeruinaTickHandler.messagePlayers(Version.textOf(message));
    }

    public static boolean isErrored(BlockEntity blockEntity) {
        if (ERRORED_BLOCK_ENTITIES.isEmpty()) {
            return false;
        }
        return ERRORED_BLOCK_ENTITIES.contains(blockEntity);
    }

    public static void addErrored(BlockEntity blockEntity) {
        ERRORED_BLOCK_ENTITIES.add(blockEntity);
    }

    public static void removeErrored(BlockEntity blockEntity) {
        ERRORED_BLOCK_ENTITIES.remove(blockEntity);
    }

    public static boolean isErrored(Entity entity) {
        if (ERRORED_ENTITIES.isEmpty()) {
            return false;
        }
        return ERRORED_ENTITIES.contains(entity);
    }

    public static void addErrored(Entity entity) {
        ERRORED_ENTITIES.add(entity);
    }

    public static void removeErrored(Entity entity) {
        ERRORED_ENTITIES.remove(entity);
    }

    public static boolean isErrored(ItemStack item) {
        if (ERRORED_ITEM_STACKS.isEmpty()) {
            return false;
        }
        return ERRORED_ITEM_STACKS.contains(item);
    }

    public static void addErrored(ItemStack item) {
        ERRORED_ITEM_STACKS.add(item);
    }

    public static boolean isErrored(BlockPos pos, BlockState state) {
        if (ERRORED_BLOCK_STATES.isEmpty()) {
            return false;
        }
        return ERRORED_BLOCK_STATES.contains(new ImmutablePair((Object)pos, (Object)state));
    }

    public static void addErrored(BlockPos pos, BlockState state) {
        ERRORED_BLOCK_STATES.add((ImmutablePair<BlockPos, BlockState>)new ImmutablePair((Object)pos, (Object)state));
    }

    public static void removeErrored(BlockPos pos, BlockState state) {
        ERRORED_BLOCK_STATES.remove(new ImmutablePair((Object)pos, (Object)state));
    }
}

