/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin;

import com.bawnorton.neruina.annotation.VersionedMixin;
import com.bawnorton.neruina.handler.NeruinaTickHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@VersionedMixin(value=">=1.19")
@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin {
    @Inject(method={"onBlockChanged"}, at={@At(value="HEAD")})
    private void removeErrored(BlockPos pos, BlockState oldBlock, BlockState newBlock, CallbackInfo ci) {
        if (NeruinaTickHandler.isErrored(pos, oldBlock)) {
            NeruinaTickHandler.removeErrored(pos, oldBlock);
        }
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;randomTick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/random/Random;)V")})
    private void catchTickingBlockState(BlockState instance, ServerLevel world, BlockPos pos, RandomSource random, Operation<Void> original) {
        NeruinaTickHandler.safelyTickBlockState$notTheCauseOfTickLag(instance, world, pos, random, original);
    }
}

