/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin;

import com.bawnorton.neruina.annotation.ConditionalMixin;
import com.bawnorton.neruina.handler.NeruinaTickHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@ConditionalMixin(modids={"noseenotick", "itshallnottick"}, applyIfPresent=false)
@Mixin(value={Level.class}, priority=1500)
public abstract class WorldMixin {
    @Inject(method={"shouldUpdatePostDeath"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldUpdatePostDeath(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (NeruinaTickHandler.isErrored(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapOperation(method={"tickEntity"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    public void catchTickingEntities(Consumer<Entity> instance, Object entity, Operation<Void> original) {
        NeruinaTickHandler.safelyTickEntities$notTheCauseOfTickLag(instance, (Entity)entity, original);
    }
}

