/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.forge.noseenotick;

import com.bawnorton.neruina.annotation.ConditionalMixin;
import com.bawnorton.neruina.annotation.VersionedMixin;
import com.bawnorton.neruina.handler.NeruinaTickHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@ConditionalMixin(modids={"noseenotick"})
@VersionedMixin(value=">=1.19")
@Mixin(value={Level.class}, priority=1500)
public abstract class WorldMixin {
    @Inject(method={"shouldUpdatePostDeath"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldUpdatePostDeath(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (NeruinaTickHandler.isErrored(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapOperation(method={"tickEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/TickOptimizer;entityTicking(Ljava/util/function/Consumer;Lnet/minecraft/entity/Entity;Lnet/minecraft/world/World;Lnet/minecraft/util/math/random/Random;)V")})
    private void catchTickingEntities(Consumer<Entity> consumer, Entity entity, Level world, RandomSource random, Operation<Void> original) {
        NeruinaTickHandler.safelyTickEntities$notTheCauseOfTickLag(consumer, entity, world, random, original);
    }
}

