/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ConditionalRunnable {
    private final ReentrantLock LOCK = new ReentrantLock();
    private boolean conditionMet = false;
    private static final ExecutorService executor = Executors.newFixedThreadPool(4);

    public static void create(Runnable task, ConditionChecker checker) {
        new ConditionalRunnable().run(task, checker);
    }

    private void run(Runnable task, ConditionChecker checker) {
        executor.execute(() -> {
            try {
                ReentrantLock reentrantLock = this.LOCK;
                synchronized (reentrantLock) {
                    while (!this.conditionMet) {
                        this.LOCK.wait(1000L);
                    }
                    task.run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        executor.execute(() -> {
            while (!checker.isCompleted()) {
                checker.run();
            }
            ReentrantLock reentrantLock = this.LOCK;
            synchronized (reentrantLock) {
                this.conditionMet = true;
                this.LOCK.notify();
            }
        });
    }

    @FunctionalInterface
    public static interface ConditionChecker
    extends Runnable {
        public static final AtomicBoolean completed = new AtomicBoolean(false);

        public boolean checkCondition();

        @Override
        default public void run() {
            completed.set(this.checkCondition());
        }

        default public boolean isCompleted() {
            return completed.get();
        }
    }
}

