/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.version.versions;

import java.util.List;
import net.minecraft.network.chat.Component;

public abstract class V118 {
    private static Class<?> literalTextClass;
    private static Class<?> translatableTextClass;

    public static Component translatable(String key, Object ... args) {
        try {
            if (args.length == 0) {
                return (Component)translatableTextClass.getConstructor(String.class).newInstance(key);
            }
            return (Component)translatableTextClass.getConstructor(String.class, Object[].class).newInstance(key, args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to get translatable text of " + key + "!", e);
        }
    }

    public static Component of(String text) {
        try {
            return (Component)literalTextClass.getConstructor(String.class).newInstance(text);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to get text of " + text + "!", e);
        }
    }

    static {
        List<String> possibleLiteralTextClassNames = List.of("net.minecraft.text.LiteralText", "net.minecraft.network.chat.TextComponent", "net.minecraft.class_2585", "net.minecraft.src.C_5025_");
        List<String> possibleTranslatableTextClassNames = List.of("net.minecraft.text.TranslatableText", "net.minecraft.network.chat.TranslatableComponent", "net.minecraft.class_2588", "net.minecraft.src.C_5026_");
        for (String className : possibleLiteralTextClassNames) {
            try {
                literalTextClass = Class.forName(className);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        for (String className : possibleTranslatableTextClassNames) {
            try {
                translatableTextClass = Class.forName(className);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (literalTextClass == null) {
            throw new RuntimeException("Could not find literal text class");
        }
        if (translatableTextClass == null) {
            throw new RuntimeException("Could not find translatable text class");
        }
    }
}

