/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud;

import io.iridium.vaultarhud.VaultarItem;
import io.iridium.vaultarhud.config.VaultarHudClientConfigs;
import io.iridium.vaultarhud.event.ClientEvents;
import io.iridium.vaultarhud.networking.ModMessages;
import io.iridium.vaultarhud.networking.packet.ClientRequestsVaultarDataC2SPacket;
import io.iridium.vaultarhud.renderers.HUDInGameRenderer;
import io.iridium.vaultarhud.renderers.HUDInventoryRenderer;
import io.iridium.vaultarhud.util.Point;
import io.iridium.vaultarhud.util.ScreenValidator;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(modid="vaultarhud", value={Dist.CLIENT})
public class VaultarHUDOverlay {
    public static List<VaultarItem> vaultarItems = new CopyOnWriteArrayList<VaultarItem>(Arrays.asList(new VaultarItem[0]));
    private static long lastChangeTime = 0L;
    public static int TICKER = 0;
    private static int CLIENTLASTCHANGEDTIME = 0;
    public static boolean isVisible = false;
    public static boolean isHUDEnabled = true;
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static BlockPos AltarLocation = null;

    @SubscribeEvent
    public static synchronized void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isCtrlDown;
        if (!ClientEvents.mode.equals((Object)ClientEvents.ModMode.CLIENTONLY)) {
            return;
        }
        Block block = event.getWorld().m_8055_(event.getPos()).m_60734_();
        BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
        long windowHandle = minecraft.m_91268_().m_85439_();
        boolean isShiftDown = GLFW.glfwGetKey((long)windowHandle, (int)340) == 1;
        boolean isAltDown = GLFW.glfwGetKey((long)windowHandle, (int)342) == 1;
        boolean bl = isCtrlDown = GLFW.glfwGetKey((long)windowHandle, (int)341) == 1;
        if (isShiftDown && isAltDown && isCtrlDown) {
            AltarLocation = null;
            vaultarItems.clear();
            return;
        }
        if (blockEntity == null || !block.getRegistryName().toString().equals("the_vault:vault_altar")) {
            return;
        }
        vaultarItems.clear();
        AltarLocation = event.getPos();
        ListTag requiredItemsList = blockEntity.m_187480_().m_128469_("Recipe").m_128437_("requiredItems", 10);
        for (Tag rawItemTag : requiredItemsList) {
            vaultarItems.add(new VaultarItem((CompoundTag)rawItemTag));
        }
    }

    @SubscribeEvent
    public static synchronized void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (!isHUDEnabled || !isVisible || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        VaultarHUDOverlay.updateVaultarItems();
        if (vaultarItems.isEmpty()) {
            return;
        }
        HUDInGameRenderer.render(event.getMatrixStack(), new Point(-1.0, 0.0));
    }

    @SubscribeEvent
    public static void onGUIScreenDraw(ScreenEvent.DrawScreenEvent.Post event) {
        if (!isHUDEnabled || !ScreenValidator.isValidScreen(event.getScreen())) {
            return;
        }
        VaultarHUDOverlay.updateVaultarItems();
        if (vaultarItems.isEmpty()) {
            return;
        }
        if (!((Boolean)VaultarHudClientConfigs.ENABLE_INVENTORY_HUD.get()).booleanValue()) {
            return;
        }
        if (((Boolean)VaultarHudClientConfigs.USE_SMALL_INVENTORY_HUD.get()).booleanValue()) {
            HUDInventoryRenderer.render(event.getPoseStack(), null);
        } else {
            HUDInGameRenderer.render(event.getPoseStack(), new Point(2.0, 0.0));
        }
    }

    private static void updateVaultarItems() {
        if (ClientEvents.mode.equals((Object)ClientEvents.ModMode.CLIENTONLY) && System.currentTimeMillis() - lastChangeTime >= 1000L) {
            lastChangeTime = System.currentTimeMillis();
            Level world = VaultarHUDOverlay.minecraft.f_91074_.f_19853_;
            if (world.m_46472_() != Level.f_46428_ && world.m_46472_() != Level.f_46429_ && world.m_46472_() != Level.f_46430_) {
                return;
            }
            Block blockToFind = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("the_vault:vault_altar"));
            if (AltarLocation == null) {
                BlockPos pos = VaultarHUDOverlay.minecraft.f_91074_.m_20097_();
                AltarLocation = VaultarHUDOverlay.isBlockNearby(world, pos, blockToFind, 10);
            }
            if (AltarLocation != null) {
                Block block = world.m_8055_(AltarLocation).m_60734_();
                BlockEntity blockEntity = world.m_7702_(AltarLocation);
                if (blockEntity == null || !block.getRegistryName().toString().equals("the_vault:vault_altar")) {
                    return;
                }
                vaultarItems.clear();
                ListTag requiredItemsList = blockEntity.m_187480_().m_128469_("Recipe").m_128437_("requiredItems", 10);
                for (Tag rawItemTag : requiredItemsList) {
                    vaultarItems.add(new VaultarItem((CompoundTag)rawItemTag));
                }
            }
        } else if (ClientEvents.mode.equals((Object)ClientEvents.ModMode.CLIENTANDSERVER)) {
            ModMessages.sendToServer(new ClientRequestsVaultarDataC2SPacket());
            if (vaultarItems.isEmpty()) {
                return;
            }
            if (System.currentTimeMillis() - lastChangeTime >= 1000L) {
                TICKER = (TICKER + 1) % 128;
                lastChangeTime = System.currentTimeMillis();
            }
        }
    }

    public static BlockPos isBlockNearby(Level world, BlockPos center, Block blockToFind, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = center.m_142082_(x, y, z);
                    if (world.m_8055_(pos).m_60734_() != blockToFind) continue;
                    return pos;
                }
            }
        }
        return null;
    }
}

