/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud;

import io.iridium.vaultarhud.util.SharedFunctions;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class VaultarItem {
    public List<ItemStack> items;
    private int countTotal;
    private int countCompleted;
    public int countInventory;

    public VaultarItem(List<ItemStack> items, int countCompleted, int countTotal) {
        this.items = items;
        this.countTotal = countTotal;
        this.countCompleted = countCompleted;
    }

    public VaultarItem(CompoundTag itemTag) {
        this.items = new ArrayList<ItemStack>();
        for (Tag rawSubItemTag : itemTag.m_128437_("items", 10)) {
            CompoundTag subItemTag = (CompoundTag)rawSubItemTag;
            String id = subItemTag.m_128461_("id");
            this.items.add(SharedFunctions.getItemStackFromTag(id));
        }
        this.countTotal = itemTag.m_128451_("amountRequired");
        this.countCompleted = itemTag.m_128451_("currentAmount");
    }

    public ItemStack getCurrentItem(int ticker) {
        return this.items.get(ticker % this.items.size());
    }

    public int getCountCompleted() {
        return this.countCompleted;
    }

    public int getCountTotal() {
        return this.countTotal;
    }

    public static List<VaultarItem> getVaultarItems(ServerPlayer player) {
        if (player == null || PlayerVaultAltarData.get((ServerLevel)player.m_183503_()) == null || PlayerVaultAltarData.get((ServerLevel)player.m_183503_()).getRecipe(player.m_142081_()) == null) {
            return new ArrayList<VaultarItem>();
        }
        ArrayList<VaultarItem> vItems = new ArrayList<VaultarItem>();
        for (RequiredItems requiredItem : PlayerVaultAltarData.get((ServerLevel)player.m_183503_()).getRecipe(player.m_142081_()).getRequiredItems()) {
            vItems.add(new VaultarItem(requiredItem.getItems(), requiredItem.getCurrentAmount(), requiredItem.getAmountRequired()));
        }
        return vItems;
    }

    public VaultarItem(FriendlyByteBuf buf) {
        this.countCompleted = buf.readInt();
        this.countTotal = buf.readInt();
        int itemSize = buf.readInt();
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < itemSize; ++i) {
            this.items.add(buf.m_130267_());
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.countCompleted);
        buf.writeInt(this.countTotal);
        buf.writeInt(this.items.size());
        for (ItemStack item : this.items) {
            buf.m_130055_(item);
        }
    }
}

