/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud.event;

import io.iridium.vaultarhud.VaultarHUDOverlay;
import io.iridium.vaultarhud.event.DoubleClickDetector;
import io.iridium.vaultarhud.networking.ModMessages;
import io.iridium.vaultarhud.networking.packet.HandshakeCheckModIsOnServerC2SPacket;
import io.iridium.vaultarhud.renderers.HUDInventoryRenderer;
import io.iridium.vaultarhud.util.KeyBindings;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {
    public static ModMode mode = ModMode.CLIENTONLY;
    private static DoubleClickDetector doubleClickDetector = new DoubleClickDetector();
    private static boolean isProcessingKeyInput = false;

    public static enum ModMode {
        CLIENTONLY,
        CLIENTANDSERVER;

    }

    @Mod.EventBusSubscriber(modid="vaultarhud", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        @SubscribeEvent
        public static void onJoinServer(ClientPlayerNetworkEvent.LoggedInEvent event) {
            mode = ModMode.CLIENTONLY;
            ModMessages.sendToServer(new HandshakeCheckModIsOnServerC2SPacket());
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.KeyInputEvent event) {
            if (KeyBindings.ENABLE_HUD.m_90859_()) {
                VaultarHUDOverlay.isHUDEnabled = !VaultarHUDOverlay.isHUDEnabled;
            }
            VaultarHUDOverlay.isVisible = KeyBindings.TOGGLE_HUD.m_90857_();
        }

        @SubscribeEvent
        public static void onGUIKeyInput(ScreenEvent.KeyboardKeyPressedEvent.Post event) {
            if (event.getScreen() instanceof InventoryScreen) {
                return;
            }
            if (KeyBindings.ENABLE_HUD.m_90832_(event.getKeyCode(), 0)) {
                VaultarHUDOverlay.isHUDEnabled = !VaultarHUDOverlay.isHUDEnabled;
            }
        }

        @SubscribeEvent
        public static void onMouseEvent(ScreenEvent.MouseClickedEvent event) {
            if (event.getButton() == 0) {
                HUDInventoryRenderer.hasMouseClicked = true;
                scheduler.schedule(() -> {
                    HUDInventoryRenderer.hasMouseClicked = false;
                    return false;
                }, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

