/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.iridium.vaultarhud.VaultarHUDOverlay;
import io.iridium.vaultarhud.VaultarHud;
import io.iridium.vaultarhud.VaultarItem;
import io.iridium.vaultarhud.renderers.ScalableItemRenderer;
import io.iridium.vaultarhud.util.Point;
import io.iridium.vaultarhud.util.SharedFunctions;
import iskallia.vault.client.ClientPartyData;
import iskallia.vault.world.data.VaultPartyData;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class HUDInGameRenderer {
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation HUD_MAIN_TEX = new ResourceLocation("vaultarhud", "textures/hud_main.png");
    private static final ResourceLocation HUD_MAIN_DARK_TEX = new ResourceLocation("vaultarhud", "textures/hud_main_dark.png");

    public static ResourceLocation getHudTexture() {
        return SharedFunctions.isDarkModeEnabled() ? HUD_MAIN_DARK_TEX : HUD_MAIN_TEX;
    }

    public static void render(PoseStack poseStack, Point origin) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        float scale = 1.0f;
        int elementSpacing = Math.round(42.0f * scale);
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        double x = origin.getX() == -1.0 ? (double)(screenWidth - Math.round(135.0f * scale)) : origin.getX();
        boolean isLeftSideRender = origin.getX() == 2.0;
        LocalPlayer player = HUDInGameRenderer.minecraft.f_91074_;
        Map<Item, Integer> inventoryItems = SharedFunctions.GetPlayerInventoryItems(player, 200);
        int itemsToRender = (int)VaultarHUDOverlay.vaultarItems.stream().filter(item -> item.getCountCompleted() != item.getCountTotal()).count();
        int y = HUDInGameRenderer.CalculateYOffsetIfPartyVisible(screenHeight, elementSpacing, isLeftSideRender, itemsToRender);
        for (VaultarItem item2 : VaultarHUDOverlay.vaultarItems) {
            List<ItemStack> suitableItems = item2.items;
            int totalSuitableItemsInInventory = 0;
            for (ItemStack stack : suitableItems) {
                Item key = stack.m_41720_();
                if (!inventoryItems.containsKey(key)) continue;
                totalSuitableItemsInInventory += inventoryItems.get(key).intValue();
            }
            if (item2.getCountCompleted() == item2.getCountTotal()) continue;
            HUDInGameRenderer.RenderMainHUDCompositeElement(poseStack, (int)x, y, item2.getCurrentItem(VaultarHUDOverlay.TICKER), item2.getCountCompleted(), item2.getCountTotal(), totalSuitableItemsInInventory, 1.0f);
            y += elementSpacing;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    private static void RenderMainHUDCompositeElement(PoseStack poseStack, int x, int y, ItemStack itemStack, int countCompleted, int countTotal, int inventoryTotal, float scale) {
        String text_name;
        int nameWidth;
        if (countCompleted == countTotal) {
            itemStack.m_41663_(Enchantment.m_44697_((int)1), 1);
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 100.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_85837_((double)(-x), (double)(-y), 0.0);
        SharedFunctions.renderBackground(poseStack, x, y, 130, 38, HUDInGameRenderer.getHudTexture());
        ScalableItemRenderer.render(itemStack, new Point((float)x + 6.0f * scale, (float)y + 5.0f * scale), scale);
        String text_count = countCompleted + "/" + countTotal;
        int stringWidth = HUDInGameRenderer.minecraft.f_91062_.m_92895_(text_count);
        int xOffset = x + 65 - stringWidth / 2;
        float progressOrange = countTotal != 0 ? (float)Math.min(countCompleted + inventoryTotal, countTotal) / (float)countTotal * 118.0f : 0.0f;
        float progressGreen = countTotal != 0 ? (float)countCompleted / (float)countTotal * 118.0f : 118.0f;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + 6), (int)(y + 29), (int)((int)Math.floor((float)(x + 6) + progressOrange)), (int)(y + 34), (int)-2913530);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(x + 6), (int)(y + 29), (int)((int)Math.floor((float)(x + 6) + progressGreen)), (int)(y + 34), (int)-16711936);
        HUDInGameRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text_count), (float)xOffset, (float)(y + 27), 0xFFFFFF);
        if (inventoryTotal > 0 && countCompleted < countTotal) {
            String text_inv = "(" + inventoryTotal + ")";
            HUDInGameRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text_inv), (float)(x + 6), (float)(y + 27), 0xFFFFFF);
        }
        if ((nameWidth = HUDInGameRenderer.minecraft.f_91062_.m_92895_(text_name = itemStack.m_41786_().getString())) > 100) {
            poseStack.m_85836_();
            float scaleF = 100.0f / (float)nameWidth;
            poseStack.m_85841_(scaleF, scaleF, 1.0f);
            HUDInGameRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text_name), (float)(x + 26) / scaleF, (float)(y + 10) / scaleF, 5569620);
            poseStack.m_85849_();
        } else {
            HUDInGameRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text_name), (float)(x + 26), (float)(y + 9), 5569620);
        }
        poseStack.m_85849_();
    }

    private static int CalculateYOffsetIfPartyVisible(int screenHeight, int elementSpacing, boolean ignoreParty, int itemsToRender) {
        VaultPartyData.Party party;
        int y = screenHeight / 2 - elementSpacing * VaultarHUDOverlay.vaultarItems.size() / 2;
        VaultPartyData.Party party2 = party = VaultarHud.ISDEBUG != false ? null : ClientPartyData.getParty((UUID)HUDInGameRenderer.minecraft.f_91074_.m_142081_());
        if (party != null && !ignoreParty) {
            int partySize = party.getMembers().size();
            y = (int)Math.max((float)screenHeight / 3.0f, 42.0f);
            y += partySize * 12 + 14;
        } else {
            y += elementSpacing * (4 - itemsToRender) / 2;
        }
        return Math.min(y, screenHeight - elementSpacing * VaultarHUDOverlay.vaultarItems.size() - 20);
    }
}

