/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.iridium.vaultarhud.VaultarHUDOverlay;
import io.iridium.vaultarhud.VaultarHud;
import io.iridium.vaultarhud.VaultarItem;
import io.iridium.vaultarhud.renderers.ScalableItemRenderer;
import io.iridium.vaultarhud.util.Point;
import io.iridium.vaultarhud.util.ScreenValidator;
import io.iridium.vaultarhud.util.SharedFunctions;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class HUDInventoryRenderer {
    private static final ResourceLocation HUD_INV_TEX = new ResourceLocation("vaultarhud", "textures/hud_inv.png");
    private static final ResourceLocation HUD_INV_TEX_DARK = new ResourceLocation("vaultarhud", "textures/hud_inv_dark.png");
    private static final ResourceLocation HUD_SMALL_INV_TEX = new ResourceLocation("vaultarhud", "textures/hud_inv_small.png");
    private static final ResourceLocation HUD_SMALL_INV_TEX_DARK = new ResourceLocation("vaultarhud", "textures/hud_inv_small_dark.png");
    private static Minecraft minecraft = Minecraft.m_91087_();
    public static boolean ShowHoverHUD = false;
    public static boolean hasMouseClicked = false;
    private static final ItemStack crystal = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_vault:vault_crystal")));
    private static final ItemStack altar = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("the_vault:vault_altar")));

    public static ResourceLocation getHudInvTexture() {
        return SharedFunctions.isDarkModeEnabled() ? HUD_INV_TEX_DARK : HUD_INV_TEX;
    }

    public static ResourceLocation getHudInvSmallTexture() {
        return SharedFunctions.isDarkModeEnabled() ? HUD_SMALL_INV_TEX_DARK : HUD_SMALL_INV_TEX;
    }

    public static void render(PoseStack poseStack, Point renderOrigin) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        float scale = 1.0f;
        int elementSpacing = Math.round(18.0f * scale);
        double GUISCALE = minecraft.m_91268_().m_85449_();
        Point offset = ScreenValidator.getScreenHUDCoordinates(HUDInventoryRenderer.minecraft.f_91080_, new Point(32.0, 28.0));
        int x = (int)offset.getX();
        int y = (int)offset.getY();
        if (hasMouseClicked && SharedFunctions.isMouseOverItem(HUDInventoryRenderer.minecraft.f_91067_.m_91589_(), HUDInventoryRenderer.minecraft.f_91067_.m_91594_(), (double)x * GUISCALE, (double)(ShowHoverHUD ? y - 59 : y) * GUISCALE, 28.0, ShowHoverHUD ? 87.0 : 28.0, (float)GUISCALE)) {
            VaultarHud.LOGGER.info("Mouse Clicked on HUD and SHowHoverHUD is " + ShowHoverHUD);
            hasMouseClicked = false;
            boolean bl = ShowHoverHUD = !ShowHoverHUD;
        }
        if (ShowHoverHUD) {
            SharedFunctions.renderBackground(poseStack, x, y -= 59, 28, 87, HUDInventoryRenderer.getHudInvTexture());
            HUDInventoryRenderer.RenderCrystal(poseStack, x + 6, y - 19, scale, true);
            boolean isHovered = SharedFunctions.isMouseOverItem(HUDInventoryRenderer.minecraft.f_91067_.m_91589_(), HUDInventoryRenderer.minecraft.f_91067_.m_91594_(), (double)x * GUISCALE, (double)y * GUISCALE, 28.0, 87.0, (float)GUISCALE);
            for (int i = 0; i < VaultarHUDOverlay.vaultarItems.size(); ++i) {
                VaultarItem item = VaultarHUDOverlay.vaultarItems.get(i);
                List<ItemStack> suitableItems = item.items;
                int totalSuitableItemsInInventory = 0;
                Map<Item, Integer> inventoryItems = SharedFunctions.GetPlayerInventoryItems(HUDInventoryRenderer.minecraft.f_91074_, 200);
                for (ItemStack stack : suitableItems) {
                    Item key = stack.m_41720_();
                    if (!inventoryItems.containsKey(key)) continue;
                    totalSuitableItemsInInventory += inventoryItems.get(key).intValue();
                }
                HUDInventoryRenderer.RenderInventoryHUDCompositeElement(poseStack, x + 6, y + 10 + elementSpacing * i, item.getCurrentItem(VaultarHUDOverlay.TICKER), item.getCountCompleted(), item.getCountTotal(), totalSuitableItemsInInventory, scale, isHovered);
            }
        } else {
            SharedFunctions.renderBackground(poseStack, x, y, 28, 28, HUDInventoryRenderer.getHudInvSmallTexture());
            HUDInventoryRenderer.RenderAltar(poseStack, x + 6, y + 8, 1.0f);
            HUDInventoryRenderer.RenderCrystal(poseStack, x + 10, y + 3, 0.5f, false);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
    }

    private static void RenderInventoryHUDCompositeElement(PoseStack poseStack, int x, int y, ItemStack itemStack, int countCompleted, int countTotal, int inventoryTotal, float scale, boolean isHovered) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 100.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_85837_((double)(-x), (double)(-y), 0.0);
        if (countCompleted == countTotal) {
            itemStack.m_41663_(Enchantment.m_44697_((int)1), 1);
        }
        ScalableItemRenderer.render(itemStack, new Point(x, y), scale);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 110.0);
        if (isHovered) {
            int pColor;
            String text = itemStack.m_41786_().getString();
            int nameWidth = HUDInventoryRenderer.minecraft.f_91062_.m_92895_(text);
            int xOffset = x - 8 - nameWidth;
            int n = pColor = countCompleted == countTotal ? 65280 : 0xFFFFFF;
            if (xOffset <= 0) {
                poseStack.m_85836_();
                float scaleF = (float)(x - 8) / (float)nameWidth;
                poseStack.m_85841_(scaleF, scaleF, 1.0f);
                HUDInventoryRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text), 0.0f / scaleF, (float)(y + 5) / scaleF, pColor);
                poseStack.m_85849_();
            } else {
                HUDInventoryRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text), (float)xOffset, (float)(y + 5), pColor);
            }
        } else {
            String text_count = countCompleted + "/" + countTotal;
            String text_invCount = inventoryTotal > 0 && countCompleted < countTotal ? " (" + inventoryTotal + ")" : "";
            int stringWidth = HUDInventoryRenderer.minecraft.f_91062_.m_92895_(text_count + text_invCount);
            int xOffset = x - 8 - stringWidth;
            int pColor = countCompleted == countTotal ? 65280 : 0xFFFFFF;
            MutableComponent invCountT = new TextComponent(text_invCount).m_130940_(ChatFormatting.GOLD);
            HUDInventoryRenderer.minecraft.f_91062_.m_92763_(poseStack, (Component)new TextComponent(text_count).m_7220_((Component)invCountT), (float)xOffset, (float)(y + 5), pColor);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static void RenderCrystal(PoseStack poseStack, int x, int y, float scale, boolean isFloating) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 200.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_85837_((double)(-x), (double)(-y), 0.0);
        ScalableItemRenderer.render(crystal, new Point(x, y), scale, isFloating, true, true);
        poseStack.m_85849_();
    }

    public static void RenderAltar(PoseStack poseStack, int x, int y, float scale) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_85837_((double)(-x), (double)(-y), 0.0);
        ScalableItemRenderer.render(altar, new Point(x, y), scale, false, false, false);
        poseStack.m_85849_();
    }
}

