/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud.util;

import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.me.items.CraftingTermScreen;
import cofh.core.client.gui.ContainerScreenCoFH;
import com.lothrazar.storagenetwork.block.inventory.ScreenNetworkInventory;
import com.lothrazar.storagenetwork.block.request.ScreenNetworkTable;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import io.iridium.vaultarhud.VaultarHud;
import io.iridium.vaultarhud.util.Point;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;

public class ScreenValidator {
    public static final List<Class<? extends Screen>> VANILLA_SCREENS = Arrays.asList(InventoryScreen.class, ContainerScreen.class, CraftingScreen.class, FurnaceScreen.class);
    public static final List<Class<? extends Screen>> RS_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(GridScreen.class);
    public static final List<Class<? extends Screen>> SOPHISTICATED_BACKPACK_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(StorageScreenBase.class);
    public static final List<Class<? extends Screen>> AE2_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(MEStorageScreen.class, CraftingTermScreen.class);
    public static final List<Class<? extends Screen>> COLOSSALCHEST_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(ContainerScreenExtended.class);
    public static final List<Class<? extends Screen>> SSN_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(ScreenNetworkInventory.class, ScreenNetworkTable.class);
    public static final List<Class<? extends Screen>> THERMAL_SCREENS = VaultarHud.ISDEBUG != false ? null : Arrays.asList(ContainerScreenCoFH.class);

    public static boolean isValidScreen(Screen screen) {
        return ScreenValidator.isScreenInList(screen, VANILLA_SCREENS) || ScreenValidator.isScreenInList(screen, RS_SCREENS) || ScreenValidator.isScreenInList(screen, SOPHISTICATED_BACKPACK_SCREENS) || ScreenValidator.isScreenInList(screen, AE2_SCREENS) || ScreenValidator.isScreenInList(screen, COLOSSALCHEST_SCREENS) || ScreenValidator.isScreenInList(screen, SSN_SCREENS) || ScreenValidator.isScreenInList(screen, THERMAL_SCREENS);
    }

    public static boolean isScreenInList(Screen screen, List<Class<? extends Screen>> screenList) {
        return screenList != null && screenList.stream().anyMatch(cls -> cls.isInstance(screen));
    }

    public static Point getScreenHUDCoordinates(Screen screen, Point offset) {
        AbstractContainerScreen gs;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        double x = 0.0;
        double y = 0.0;
        if (ScreenValidator.isScreenInList(screen, VANILLA_SCREENS)) {
            x = (double)((screenWidth - 176) / 2) - offset.getX();
            y = (double)((screenHeight + 166) / 2) - offset.getY();
        }
        if (ScreenValidator.isScreenInList(screen, SOPHISTICATED_BACKPACK_SCREENS)) {
            gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - 176) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY();
        }
        if (ScreenValidator.isScreenInList(screen, RS_SCREENS)) {
            gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - gs.getXSize()) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY() - 1.0;
        }
        if (ScreenValidator.isScreenInList(screen, AE2_SCREENS) || ScreenValidator.isScreenInList(screen, COLOSSALCHEST_SCREENS) || ScreenValidator.isScreenInList(screen, SSN_SCREENS) || ScreenValidator.isScreenInList(screen, THERMAL_SCREENS)) {
            gs = (AbstractContainerScreen)screen;
            x = (double)((screenWidth - gs.getXSize()) / 2) - offset.getX();
            y = (double)((screenHeight + gs.getYSize()) / 2) - offset.getY();
        }
        return new Point(x, y);
    }
}

