/*
 * Decompiled with CFR 0.152.
 */
package io.iridium.vaultarhud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.util.InventoryUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestBackpackInventoryContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;

public class SharedFunctions {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static double lastMouseX = -1.0;
    private static double lastMouseY = -1.0;
    private static boolean lastMouseState = false;
    public static Map<Item, Integer> CachedInventoryItems = new HashMap<Item, Integer>();
    public static long lastCheckedTime = 0L;
    private static boolean cachedDarkMode = false;
    private static long lastCheckTime = 0L;

    public static String formatNumber(int number) {
        if (number > 1000) {
            return SharedFunctions.round(number / 1000, 1) + "k";
        }
        return String.valueOf(number);
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static boolean isBlock(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BlockItem;
    }

    public static BakedModel getBakedModel(ItemStack itemStack, ItemRenderer itemRenderer) {
        return itemRenderer.m_115103_().m_109406_(itemStack);
    }

    public static boolean isInVault() {
        ClientLevel level = SharedFunctions.minecraft.f_91073_;
        String dimension = level.m_46472_().m_135782_().toString();
        return !dimension.equals("minecraft:overworld") && !dimension.equals("minecraft:the_nether") && !dimension.equals("minecraft:the_end");
    }

    public static boolean isMouseOverItem(double mouseX, double mouseY, double itemX, double itemY, double itemWidth, double itemHeight, float scale) {
        if (mouseX == lastMouseX && mouseY == lastMouseY) {
            return lastMouseState;
        }
        lastMouseX = mouseX;
        lastMouseY = mouseY;
        itemWidth = (int)(itemWidth * (double)scale);
        itemHeight = (int)(itemHeight * (double)scale);
        lastMouseState = mouseX >= itemX && mouseY >= itemY && mouseX < itemX + itemWidth && mouseY < itemY + itemHeight;
        return lastMouseState;
    }

    public static ItemStack getItemStackFromTag(String tag) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag));
        return new ItemStack((ItemLike)item);
    }

    public static void renderBackground(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)width, (float)height, (int)width, (int)height, (int)width, (int)height);
    }

    public static ItemStack getItemStack(String item) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
    }

    public static Map<Item, Integer> GetPlayerInventoryItems(LocalPlayer player, Integer cacheTimeout) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCheckedTime < (long)cacheTimeout.intValue()) {
            return new HashMap<Item, Integer>(CachedInventoryItems);
        }
        HashMap<Item, Integer> InventoryItems = new HashMap<Item, Integer>();
        for (InventoryUtil.ItemAccess items : InventoryUtil.findAllItems((Player)player)) {
            ItemStack stack = items.getStack();
            if (stack.m_41619_()) continue;
            Item key = stack.m_41720_();
            InventoryItems.put(key, InventoryItems.getOrDefault(key, 0) + stack.m_41613_());
            if (!(key instanceof BackpackItem)) continue;
            stack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> SBPPacketHandler.INSTANCE.sendToServer((Object)new RequestBackpackInventoryContentsMessage(uuid))));
        }
        CachedInventoryItems = InventoryItems;
        lastCheckedTime = currentTime;
        return new HashMap<Item, Integer>(CachedInventoryItems);
    }

    public static boolean isResourcePackLoaded(String packName) {
        return minecraft.m_91099_().m_10523_().stream().anyMatch(pack -> pack.equals(packName));
    }

    public static boolean isDarkModeEnabled() {
        if (System.currentTimeMillis() - lastCheckTime < 20000L) {
            return cachedDarkMode;
        }
        return SharedFunctions.isResourcePackLoaded("file/Void_Hunters_Dark_UI.zip") || SharedFunctions.isResourcePackLoaded("file/Void_Hunters_Dark_UI");
    }
}

