/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.crafting_on_a_stick;

import com.ofek2608.crafting_on_a_stick.ItemOnAStick;
import com.ofek2608.crafting_on_a_stick.MinecraftMenuBuilder;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModItems {
    private static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crafting_on_a_stick");
    private static final RegistryObject<ItemOnAStick> CRAFTING_TABLE;
    private static final RegistryObject<ItemOnAStick> LOOM;
    private static final RegistryObject<ItemOnAStick> GRINDSTONE;
    private static final RegistryObject<ItemOnAStick> CARTOGRAPHY_TABLE;
    private static final RegistryObject<ItemOnAStick> STONECUTTER;
    private static final RegistryObject<ItemOnAStick> SMITHING_TABLE;
    private static final RegistryObject<ItemOnAStick> ANVIL;
    private static final RegistryObject<ItemOnAStick> CHIPPED_ANVIL;
    private static final RegistryObject<ItemOnAStick> DAMAGED_ANVIL;

    private ModItems() {
    }

    public static void load() {
    }

    private static boolean doPlayerHave(Player player, RegistryObject<ItemOnAStick> itemReg) {
        Item item = (Item)itemReg.get();
        Inventory inventory = player.m_150109_();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack invStack = inventory.m_8020_(i);
            if (invStack.m_41619_() || invStack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    private static RegistryObject<ItemOnAStick> createItem(Block block, String containerName, MinecraftMenuBuilder builder) {
        String path = block.getRegistryName().m_135815_();
        return REGISTER.register(path, () -> new ItemOnAStick(block, containerName, builder));
    }

    private static RegistryObject<ItemOnAStick> createAnvil(Block block) {
        return ModItems.createItem(block, "repair", (a, b, c) -> new AnvilMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, DAMAGED_ANVIL) || ModItems.doPlayerHave(player, CHIPPED_ANVIL) || ModItems.doPlayerHave(player, ANVIL);
            }

            protected void m_142365_(Player p_150474_, ItemStack p_150475_) {
                if (!p_150474_.m_150110_().f_35937_) {
                    p_150474_.m_6749_(-this.m_39028_());
                }
                float breakChance = ForgeHooks.onAnvilRepair((Player)p_150474_, (ItemStack)p_150475_, (ItemStack)this.f_39769_.m_8020_(0), (ItemStack)this.f_39769_.m_8020_(1));
                this.f_39769_.m_6836_(0, ItemStack.f_41583_);
                if (this.f_39000_ > 0) {
                    ItemStack itemstack = this.f_39769_.m_8020_(1);
                    if (!itemstack.m_41619_() && itemstack.m_41613_() > this.f_39000_) {
                        itemstack.m_41774_(this.f_39000_);
                        this.f_39769_.m_6836_(1, itemstack);
                    } else {
                        this.f_39769_.m_6836_(1, ItemStack.f_41583_);
                    }
                } else {
                    this.f_39769_.m_6836_(1, ItemStack.f_41583_);
                }
                this.setMaximumCost(0);
                this.f_39770_.m_39292_((p_150479_, p_150480_) -> p_150479_.m_46796_(ModItems.damageAnvil(p_150474_, breakChance) ? 1029 : 1030, p_150480_, 0));
            }
        });
    }

    private static boolean damageAnvil(Player player, float breakChance) {
        if (player.m_150110_().f_35937_ || player.m_21187_().nextFloat() >= breakChance) {
            return false;
        }
        ItemStack candidate = ModItems.damageAnvilItemStack(player.m_21120_(InteractionHand.MAIN_HAND));
        if (candidate != null) {
            player.m_21008_(InteractionHand.MAIN_HAND, candidate);
            return candidate.m_41619_();
        }
        candidate = ModItems.damageAnvilItemStack(player.m_21120_(InteractionHand.OFF_HAND));
        if (candidate != null) {
            player.m_21008_(InteractionHand.OFF_HAND, candidate);
            return candidate.m_41619_();
        }
        Inventory inventory = player.m_150109_();
        int invSize = inventory.m_6643_();
        for (int i = 0; i < invSize; ++i) {
            candidate = ModItems.damageAnvilItemStack(inventory.m_8020_(i));
            if (candidate == null) continue;
            inventory.m_6836_(i, candidate);
            return candidate.m_41619_();
        }
        return false;
    }

    @Nullable
    private static ItemStack damageAnvilItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item == ANVIL.get()) {
            return new ItemStack((ItemLike)CHIPPED_ANVIL.get());
        }
        if (item == CHIPPED_ANVIL.get()) {
            return new ItemStack((ItemLike)DAMAGED_ANVIL.get());
        }
        if (item == DAMAGED_ANVIL.get()) {
            return ItemStack.f_41583_;
        }
        return null;
    }

    static {
        REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        CRAFTING_TABLE = ModItems.createItem(Blocks.f_50091_, "crafting", (a, b, c) -> new CraftingMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, CRAFTING_TABLE);
            }
        });
        LOOM = ModItems.createItem(Blocks.f_50617_, "loom", (a, b, c) -> new LoomMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, LOOM);
            }
        });
        GRINDSTONE = ModItems.createItem(Blocks.f_50623_, "grindstone_title", (a, b, c) -> new GrindstoneMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, GRINDSTONE);
            }
        });
        CARTOGRAPHY_TABLE = ModItems.createItem(Blocks.f_50621_, "cartography_table", (a, b, c) -> new CartographyTableMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, CARTOGRAPHY_TABLE);
            }
        });
        STONECUTTER = ModItems.createItem(Blocks.f_50679_, "stonecutter", (a, b, c) -> new StonecutterMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, STONECUTTER);
            }
        });
        SMITHING_TABLE = ModItems.createItem(Blocks.f_50625_, "upgrade", (a, b, c) -> new SmithingMenu(a, b, c){

            public boolean m_6875_(Player player) {
                return ModItems.doPlayerHave(player, SMITHING_TABLE);
            }
        });
        ANVIL = ModItems.createAnvil(Blocks.f_50322_);
        CHIPPED_ANVIL = ModItems.createAnvil(Blocks.f_50323_);
        DAMAGED_ANVIL = ModItems.createAnvil(Blocks.f_50324_);
    }
}

