/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.CobbleGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CobbleGolemModel
extends EntityModel<CobbleGolem> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public CobbleGolemModel(ModelPart root) {
        this.root = root.m_171324_("cobble_golem");
        ModelPart body = this.root.m_171324_("bodylower").m_171324_("body");
        this.head = body.m_171324_("head");
        this.rightarm = body.m_171324_("rightarm");
        this.leftarm = body.m_171324_("leftarm");
        this.rightleg = this.root.m_171324_("rightleg");
        this.leftleg = this.root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition cobble_golem = partdefinition.m_171599_("cobble_golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodylower = cobble_golem.m_171599_("bodylower", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-4.0f, -2.0f, -3.0f, 8.0f, 4.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = bodylower.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-7.0f, -12.0f, -7.0f, 14.0f, 12.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)-7.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-6.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f).m_171514_(44, 18).m_171481_(-5.0f, 8.0f, -2.0f, 4.0f, 14.0f, 4.0f), PartPose.m_171423_((float)-7.0f, (float)-8.0f, (float)-3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = body.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171480_().m_171481_(0.0f, -4.0f, -3.0f, 6.0f, 12.0f, 6.0f).m_171555_(false).m_171514_(44, 18).m_171481_(1.0f, 8.0f, -2.0f, 4.0f, 14.0f, 4.0f), PartPose.m_171423_((float)7.0f, (float)-8.0f, (float)-3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = cobble_golem.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(44, 36).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.m_171423_((float)-3.0f, (float)-8.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(44, 45).m_171481_(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = cobble_golem.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(44, 36).m_171480_().m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)-8.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(44, 45).m_171480_().m_171481_(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 4.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(CobbleGolem cobbleGolem, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)cobbleGolem, limbSwing, limbSwingAmount, partialTick);
        int i = cobbleGolem.getAttackAnimationTick();
        float rotation = -0.2617994f;
        if (i > 0) {
            this.rightarm.f_104203_ = rotation - 2.0f + 1.5f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
            this.leftarm.f_104203_ = rotation - 2.0f + 1.5f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.rightarm.f_104203_ = rotation + (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftarm.f_104203_ = rotation + (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void setupAnim(CobbleGolem cobbleGolem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.rightleg.f_104203_ = -1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightleg.f_104203_ -= 0.1745329f;
        this.leftleg.f_104203_ = 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftleg.f_104203_ -= 0.1745329f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

