/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Dryad;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;

public class DryadModel
extends EntityModel<Dryad>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart headFlower;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public DryadModel(ModelPart root) {
        this.root = root.m_171324_("dryad");
        ModelPart bodybottom = this.root.m_171324_("bodybottom");
        this.bodytop = bodybottom.m_171324_("bodymiddle").m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.headeyes = this.head.m_171324_("headeyes");
        this.headFlower = this.head.m_171324_("headflower");
        this.hair1 = neck.m_171324_("hair1");
        this.hair2 = this.hair1.m_171324_("hair2");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        this.leftleg = this.root.m_171324_("leftleg");
        this.rightleg = this.root.m_171324_("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition dryad = partdefinition.m_171599_("dryad", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition bodybottom = dryad.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -2.5f, -1.5f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.m_171599_("rightear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition rightear_r1 = rightear.m_171599_("rightear_r1", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.0459f, (float)0.0457f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition leftear = head.m_171599_("leftear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition leftear_r1 = leftear.m_171599_("leftear_r1", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.0459f, (float)0.0457f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition headeyes = head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headflower = head.m_171599_("headflower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headflower_r1 = headflower.m_171599_("headflower_r1", CubeListBuilder.m_171558_().m_171514_(36, 39).m_171481_(-2.0f, -1.5f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.m_171423_((float)-3.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition hair1 = neck.m_171599_("hair1", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171481_(-4.0f, -4.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.m_171599_("hair2", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-4.5f, 1.0f, -1.5f, 9.0f, 9.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition chest = bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(-2.2f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171480_().m_171481_(0.2f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171480_().m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171480_().m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition waist = bodymiddle.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-3.5f, 0.0f, -3.5f, 7.0f, 6.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition waist2_r1 = waist.m_171599_("waist2_r1", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = dryad.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.m_171423_((float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition rightleglower = rightleg.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171481_(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)-1.5f));
        PartDefinition leftleg = dryad.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171480_().m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 7.0f, 3.0f).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition leftleglower = leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171480_().m_171481_(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)-1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Dryad dryad, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)dryad, limbSwing, limbSwingAmount, partialTick);
        this.headFlower.f_104207_ = !dryad.m_6162_();
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !dryad.m_6162_();
    }

    public void setupAnim(Dryad dryad, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.f_104207_ = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.hair1.f_104204_ = this.head.f_104204_;
        this.hair1.f_104203_ = this.head.f_104203_;
        this.hair2.f_104203_ = this.head.f_104203_ * 0.75f;
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        if (this.f_102608_ > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.2617994f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.2617994f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        if (dryad.isFleeing()) {
            Vec3 movement = dryad.m_20184_();
            if (movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_ > 2.500000277905201E-7) {
                this.animationFlee();
            }
        }
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightleg.f_104204_ = 0.0f;
        this.leftleg.f_104204_ = 0.0f;
        this.rightleg.f_104205_ = -0.0349066f;
        this.leftleg.f_104205_ = 0.0349066f;
        if (this.f_102609_) {
            this.rightarm.f_104203_ -= 0.62831855f;
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.leftarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationFlee() {
        this.rightarm.f_104203_ += 1.0472f;
        this.leftarm.f_104203_ += 1.0472f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(-0.0625, 0.5, 0.0);
        this.getArm(arm).m_104299_(poseStack);
    }
}

