/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Dwarf;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class DwarfModel
extends EntityModel<Dwarf>
implements HeadedModel,
ArmedModel {
    private final ModelPart head;
    private final ModelPart headLight;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public DwarfModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.headLight = this.head.m_171324_("headlight");
        this.body = root.m_171324_("body");
        this.rightarm = root.m_171324_("rightarm");
        this.leftarm = root.m_171324_("leftarm");
        this.rightleg = root.m_171324_("rightleg");
        this.leftleg = root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition headlight = head.m_171599_("headlight", CubeListBuilder.m_171558_().m_171514_(64, 44).m_171481_(-1.5f, -9.0f, -5.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headaccessory = head.m_171599_("headaccessory", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headbeard = head.m_171599_("headbeard", CubeListBuilder.m_171558_().m_171514_(64, 18).m_171481_(-4.5f, -2.0f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = head.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(64, 36).m_171481_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-4.0f, -2.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightarmpauldron = rightarm.m_171599_("rightarmpauldron", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171481_(-3.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarmgauntlet = rightarm.m_171599_("rightarmgauntlet", CubeListBuilder.m_171558_().m_171514_(100, 10).m_171481_(-3.5f, 3.5f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftarmpauldron = leftarm.m_171599_("leftarmpauldron", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171480_().m_171481_(-1.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarmgauntlet = leftarm.m_171599_("leftarmgauntlet", CubeListBuilder.m_171558_().m_171514_(100, 10).m_171480_().m_171481_(-1.5f, 3.5f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)14.0f, (float)0.0f));
        PartDefinition rightlegupper = rightleg.m_171599_("rightlegupper", CubeListBuilder.m_171558_().m_171514_(100, 20).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegboot = rightleg.m_171599_("rightlegboot", CubeListBuilder.m_171558_().m_171514_(100, 30).m_171481_(-2.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)14.0f, (float)0.0f));
        PartDefinition leftlegupper = leftleg.m_171599_("leftlegupper", CubeListBuilder.m_171558_().m_171514_(100, 20).m_171480_().m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftlegboot = leftleg.m_171599_("leftlegboot", CubeListBuilder.m_171558_().m_171514_(100, 30).m_171480_().m_171481_(-2.5f, 5.0f, -2.5f, 5.0f, 5.0f, 5.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Dwarf dwarf, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)dwarf, limbSwing, limbSwingAmount, partialTick);
        this.headLight.f_104207_ = dwarf.getVariant() == 2;
    }

    public void setupAnim(Dwarf dwarf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        ItemStack itemstack = dwarf.m_21205_();
        if (dwarf.m_5912_() && itemstack.m_41720_() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.f_102608_ > -9990.0f) {
            this.holdingMelee();
        }
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.0872665f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.0872665f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightleg.f_104204_ = 0.0f;
        this.leftleg.f_104204_ = 0.0f;
        this.rightleg.f_104205_ = 0.0f;
        this.leftleg.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.rightarm.f_104203_ -= 0.62831855f;
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
        this.rightarm.f_104205_ = -0.3f;
        this.leftarm.f_104205_ = 0.3f;
        this.rightarm.f_104204_ = -(0.1f - f * 0.6f);
        this.leftarm.f_104204_ = 0.3f - f * 0.6f;
        this.rightarm.f_104203_ = -1.5707964f;
        this.leftarm.f_104203_ = -1.5707964f;
        this.rightarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        this.leftarm.f_104203_ -= f * 1.2f - f1 * 0.4f;
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.body.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftleg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }
}

