/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Naga;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class NagaModel
extends EntityModel<Naga>
implements HeadedModel,
ArmedModel {
    private static final double CYCLES_PER_BLOCK = 0.1;
    private final float[][] undulationCycle = new float[][]{{5.0f, 0.0f, -11.25f, -45.0f, -22.5f, 0.0f, 22.5f, 45.0f}, {10.0f, 10.0f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f, 22.5f}, {5.0f, 20.0f, 11.25f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f}, {0.0f, 10.0f, 22.5f, 22.5f, 0.0f, -22.5f, -45.0f, -22.5f}, {-5.0f, 0.0f, 11.25f, 45.0f, 22.5f, 0.0f, -22.5f, -45.0f}, {-10.0f, -10.0f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f, -22.5f}, {-5.0f, -20.0f, -11.25f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f}, {0.0f, -10.0f, -22.5f, -22.5f, 0.0f, 22.5f, 45.0f, 22.5f}};
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart rightarmlower;
    private final ModelPart leftarm;
    private final ModelPart leftarmlower;
    private final ModelPart[] tails = new ModelPart[8];

    public NagaModel(ModelPart root) {
        this.root = root.m_171324_("naga");
        this.body = this.root.m_171324_("waist").m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightarm = this.body.m_171324_("rightarm");
        this.rightarmlower = this.rightarm.m_171324_("rightarmlower");
        this.leftarm = this.body.m_171324_("leftarm");
        this.leftarmlower = this.leftarm.m_171324_("leftarmlower");
        for (int i = 0; i < this.tails.length; ++i) {
            int index = i + 1;
            this.tails[i] = index == 1 ? this.root.m_171324_("tail" + index) : this.tails[i - 1].m_171324_("tail" + index);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition naga = partdefinition.m_171599_("naga", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition waist = naga.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171481_(-4.5f, -5.0f, 0.0f, 9.0f, 5.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)-17.0f, (float)-2.5f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition body = waist.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(34, 44).m_171481_(-5.5f, -9.0f, -3.0f, 11.0f, 9.0f, 6.0f).m_171514_(104, 39).m_171481_(0.0f, -14.0f, -3.0f, 0.0f, 13.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)2.5f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(34, 14).m_171481_(-4.5f, -4.0f, -2.0f, 9.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -5.0f, 6.0f, 5.0f, 7.0f).m_171514_(0, 46).m_171481_(0.0f, -8.0f, -5.0f, 0.0f, 5.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)-1.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition headnose = head.m_171599_("headnose", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-2.0f, 0.0f, -5.0f, 4.0f, 3.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        headnose.m_171599_("headbrowleft_r1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)0.5236f, (float)0.0f));
        headnose.m_171599_("headbrowright_r1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        head.m_171599_("headjaw", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.5f, -2.0f, -6.5f, 5.0f, 3.0f, 6.0f).m_171514_(0, 34).m_171481_(-3.0f, -1.0f, -7.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-2.0f));
        head.m_171599_("rightfin", CubeListBuilder.m_171558_().m_171514_(19, -5).m_171481_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.m_171599_("leftfin", CubeListBuilder.m_171558_().m_171514_(19, -5).m_171481_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightarm = body.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(34, 22).m_171481_(-3.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.m_171423_((float)-5.5f, (float)-6.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        rightarm.m_171599_("rightpauldron_r1", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-5.0f, -2.5f, -3.0f, 7.0f, 7.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(34, 33).m_171481_(-1.501f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f), PartPose.m_171419_((float)-1.5f, (float)6.5f, (float)1.5f));
        PartDefinition leftarm = body.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(34, 22).m_171481_(0.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.m_171423_((float)5.5f, (float)-6.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        leftarm.m_171599_("leftpauldron_r1", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171480_().m_171481_(-2.0f, -2.5f, -3.0f, 7.0f, 7.0f, 7.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(34, 33).m_171481_(-1.499f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f), PartPose.m_171419_((float)1.5f, (float)6.5f, (float)1.5f));
        PartDefinition tail1 = naga.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(68, 10).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)-2.5f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(68, 24).m_171481_(-3.5f, 0.0f, 0.0f, 7.0f, 7.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(68, 37).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition tail4 = tail3.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(68, 49).m_171481_(-2.5f, 0.0f, 0.5f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition tail5 = tail4.m_171599_("tail5", CubeListBuilder.m_171558_().m_171514_(68, 49).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.5f));
        PartDefinition tail6 = tail5.m_171599_("tail6", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition tail7 = tail6.m_171599_("tail7", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        tail7.m_171599_("tail8", CubeListBuilder.m_171558_().m_171514_(96, 8).m_171481_(-1.5f, 0.0f, 0.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Naga naga, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        float armDefaultAngleX = 0.261799f;
        if (naga.getAnimationState() == 0) {
            this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104205_ = 0.0f;
            if (this.f_102608_ > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.rightarm.f_104203_ = armDefaultAngleX;
            this.leftarm.f_104203_ = armDefaultAngleX;
            this.rightarmlower.f_104203_ = -armDefaultAngleX;
            this.leftarmlower.f_104203_ = -armDefaultAngleX;
        } else {
            this.animationBuff();
        }
        this.tails[0].f_104203_ = -0.1308997f;
        this.tails[1].f_104203_ = 0.3926991f;
        this.tails[2].f_104203_ = 0.3926991f;
        this.tails[3].f_104203_ = 0.785398f;
        this.tails[4].f_104203_ = 0.1309f;
        this.tails[7].f_104203_ = 0.3926991f;
        int cycleIndex = (int)((double)limbSwing * 0.1 % (double)this.undulationCycle.length);
        this.tails[4].f_104205_ = 0.15f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][4])));
        this.tails[5].f_104205_ = 0.15f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][5])));
        this.tails[6].f_104205_ = 0.15f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][6])));
        this.tails[7].f_104205_ = 0.15f * Mth.m_14089_((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][7])));
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.body.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        float armDefaultAngleX = 0.785398f;
        this.rightarm.f_104203_ = 0.0f;
        this.leftarm.f_104203_ = 0.0f;
        this.rightarm.f_104205_ = armDefaultAngleX;
        this.leftarm.f_104205_ = -armDefaultAngleX;
        this.rightarm.f_104203_ = armDefaultAngleX;
        this.leftarm.f_104203_ = armDefaultAngleX;
        this.rightarmlower.f_104203_ = -armDefaultAngleX;
        this.leftarmlower.f_104203_ = -armDefaultAngleX;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(-0.125, 0.5, 0.0);
        if (arm == HumanoidArm.LEFT) {
            poseStack.m_85837_(0.125, 0.0, 0.0625);
        }
        this.getArm(arm).m_104299_(poseStack);
    }
}

