/*
 * Decompiled with CFR 0.152.
 */
package gaia.config;

import gaia.config.SpawningInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GaiaSpawningConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SafeVarargs
    public static List<String> generateList(ResourceKey<Biome> ... biomes) {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceKey<Biome> biome : biomes) {
            list.add(biome.m_135782_().toString());
        }
        return list;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final SpawningInfo antHillSpawning;
        public final SpawningInfo antSalvagerSpawning;
        public final SpawningInfo anubisSpawning;
        public final SpawningInfo arachneSpawning;
        public final SpawningInfo bansheeSpawning;
        public final SpawningInfo beeSpawning;
        public final SpawningInfo behenderSpawning;
        public final SpawningInfo boneKnightSpawning;
        public final SpawningInfo cecaeliaSpawning;
        public final SpawningInfo centaurSpawning;
        public final SpawningInfo cobbleGolemSpawning;
        public final SpawningInfo cobblestoneGolemSpawning;
        public final SpawningInfo creepSpawning;
        public final SpawningInfo cyclopsSpawning;
        public final SpawningInfo mandragoraSpawning;
        public final SpawningInfo deathwordSpawning;
        public final SpawningInfo dryadSpawning;
        public final SpawningInfo dullahanSpawning;
        public final SpawningInfo dwarfSpawning;
        public final SpawningInfo enderDragonGirlSpawning;
        public final SpawningInfo enderEyeSpawning;
        public final SpawningInfo fleshLichSpawning;
        public final SpawningInfo gelatinousSlimeSpawning;
        public final SpawningInfo goblinSpawning;
        public final SpawningInfo gryphonSpawning;
        public final SpawningInfo harpySpawning;
        public final SpawningInfo hunterSpawning;
        public final SpawningInfo koboldSpawning;
        public final SpawningInfo matangoSpawning;
        public final SpawningInfo mermaidSpawning;
        public final SpawningInfo mimicSpawning;
        public final SpawningInfo minotaurSpawning;
        public final SpawningInfo minotaurusSpawning;
        public final SpawningInfo mummySpawning;
        public final SpawningInfo nagaSpawning;
        public final SpawningInfo nineTailsSpawning;
        public final SpawningInfo oniSpawning;
        public final SpawningInfo orcSpawning;
        public final SpawningInfo satyressSpawning;
        public final SpawningInfo shamanSpawning;
        public final SpawningInfo sharkoSpawning;
        public final SpawningInfo sirenSpawning;
        public final SpawningInfo sludgeGirlSpawning;
        public final SpawningInfo sphinxSpawning;
        public final SpawningInfo sprigganSpawning;
        public final SpawningInfo succubusSpawning;
        public final SpawningInfo toadSpawning;
        public final SpawningInfo valkyrieSpawning;
        public final SpawningInfo werecatSpawning;
        public final SpawningInfo witchSpawning;
        public final SpawningInfo witherCowSpawning;
        public final SpawningInfo wizardHarpySpawning;
        public final SpawningInfo yukiOnnaSpawning;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Spawning settings").push("Spawning");
            List<String> antHillBiomes = GaiaSpawningConfig.generateList(Biomes.f_48203_);
            List<String> antHillBiomeDictionary = List.of("OVERWORLD,SANDY,!MESA");
            this.antHillSpawning = new SpawningInfo(builder, "AntHill", 20, 1, 1, antHillBiomes, antHillBiomeDictionary);
            List<String> antSalvagerBiomes = GaiaSpawningConfig.generateList(Biomes.f_48203_);
            List<String> antSalvagerBiomeDictionary = List.of("OVERWORLD,SANDY,!MESA");
            this.antSalvagerSpawning = new SpawningInfo(builder, "AntSalvager", 20, 2, 5, antSalvagerBiomes, antSalvagerBiomeDictionary);
            List<String> anubisBiomes = GaiaSpawningConfig.generateList(Biomes.f_48203_);
            List<String> anubisBiomeDictionary = List.of("OVERWORLD,SANDY,!MESA");
            this.anubisSpawning = new SpawningInfo(builder, "Anubis", 20, 2, 4, anubisBiomes, anubisBiomeDictionary);
            List<String> arachneBiomeDictionary = List.of("OVERWORLD");
            this.arachneSpawning = new SpawningInfo(builder, "Arachne", 80, 1, 2, List.of(), arachneBiomeDictionary);
            List<String> bansheeBiomes = GaiaSpawningConfig.generateList(Biomes.f_186754_, Biomes.f_186765_, Biomes.f_186766_);
            List<String> bansheeBiomeDictionary = List.of("OVERWORLD,PLATEAU,!COLD,!HOT,!DENSE", "OVERWORLD,MOUNTAIN,!HOT,!DENSE");
            this.bansheeSpawning = new SpawningInfo(builder, "Banshee", 80, 2, 4, bansheeBiomes, bansheeBiomeDictionary);
            List<String> beeBiomes = GaiaSpawningConfig.generateList(Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
            List<String> beeBiomeDictionary = List.of("OVERWORLD,FOREST,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY,!DENSE", "OVERWORLD,FOREST,DENSE,RARE,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY");
            this.beeSpawning = new SpawningInfo(builder, "Bee", 80, 2, 4, beeBiomes, beeBiomeDictionary);
            List<String> behenderBiomeDictionary = List.of("END,COLD,DRY");
            this.behenderSpawning = new SpawningInfo(builder, "Behender", 1, 1, 1, List.of(), behenderBiomeDictionary, true);
            List<String> boneKnightBiomeDictionary = List.of("OVERWORLD");
            this.boneKnightSpawning = new SpawningInfo(builder, "BoneKnight", 40, 1, 2, List.of(), boneKnightBiomeDictionary, true);
            List<String> cecaeliaBiomes = GaiaSpawningConfig.generateList(Biomes.f_48217_, Biomes.f_48174_, Biomes.f_48166_, Biomes.f_48208_);
            List<String> cecaeliaBiomeDictionary = List.of("OVERWORLD,BEACH", "OVERWORLD,WATER");
            this.cecaeliaSpawning = new SpawningInfo(builder, "Cecaelia", 80, 4, 6, cecaeliaBiomes, cecaeliaBiomeDictionary);
            List<String> centaurBiomes = GaiaSpawningConfig.generateList(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48159_, Biomes.f_48194_);
            List<String> centaurBiomeDictionary = List.of("OVERWORLD,PLAINS,!SAVANNA", "OVERWORLD,MESA");
            this.centaurSpawning = new SpawningInfo(builder, "Centaur", 20, 4, 6, centaurBiomes, centaurBiomeDictionary);
            List<String> cobbleGolemBiomes = GaiaSpawningConfig.generateList(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_48197_);
            List<String> cobbleGolemBiomeDictionary = List.of("OVERWORLD,JUNGLE");
            this.cobbleGolemSpawning = new SpawningInfo(builder, "CobbleGolem", 60, 2, 4, cobbleGolemBiomes, cobbleGolemBiomeDictionary);
            List<String> cobblestoneGolemBiomes = GaiaSpawningConfig.generateList(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_48197_);
            List<String> cobblestoneGolemBiomeDictionary = List.of("OVERWORLD,JUNGLE");
            this.cobblestoneGolemSpawning = new SpawningInfo(builder, "CobblestoneGolem", 60, 2, 4, cobblestoneGolemBiomes, cobblestoneGolemBiomeDictionary);
            List<String> creepBiomeDictionary = List.of("OVERWORLD");
            this.creepSpawning = new SpawningInfo(builder, "Creep", 80, 2, 4, List.of(), creepBiomeDictionary, true);
            List<String> cyclopsBiomes = GaiaSpawningConfig.generateList(Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186763_, Biomes.f_186764_);
            List<String> cyclopsBiomeDictionary = List.of("OVERWORLD,FOREST,CONIFEROUS,!SNOWY");
            this.cyclopsSpawning = new SpawningInfo(builder, "Cyclops", 40, 4, 6, cyclopsBiomes, cyclopsBiomeDictionary);
            List<String> mandragoraBiomes = GaiaSpawningConfig.generateList(Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
            List<String> mandragoraBiomeDictionary = List.of("OVERWORLD,FOREST,CONIFEROUS,!SNOWY", "OVERWORLD,FOREST,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY,!DENSE", "OVERWORLD,FOREST,DENSE,RARE,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY");
            this.mandragoraSpawning = new SpawningInfo(builder, "Mandragora", 60, 1, 2, mandragoraBiomes, mandragoraBiomeDictionary);
            List<String> deathwordBiomeDictionary = List.of("OVERWORLD");
            this.deathwordSpawning = new SpawningInfo(builder, "Deathword", 40, 1, 2, List.of(), deathwordBiomeDictionary, true);
            List<String> dryadBiomes = GaiaSpawningConfig.generateList(Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
            List<String> dryadBiomeDictionary = List.of("OVERWORLD,FOREST,!CONIFEROUS,!COLD,!HOT,!SPARSE,SPOOKY,!DENSE", "OVERWORLD,FOREST,DENSE,RARE,!CONIFEROUS,!COLD,!HOT,!SPARSE,SPOOKY");
            this.dryadSpawning = new SpawningInfo(builder, "Dryad", 60, 4, 6, dryadBiomes, dryadBiomeDictionary);
            List<String> dullahanBiomes = GaiaSpawningConfig.generateList(Biomes.f_186754_, Biomes.f_186765_, Biomes.f_186766_);
            List<String> dullahanBiomeDictionary = List.of("OVERWORLD,PLATEAU,!COLD,!HOT,!DENSE", "OVERWORLD,MOUNTAIN,!HOT,!DENSE");
            this.dullahanSpawning = new SpawningInfo(builder, "Dullahan", 100, 4, 6, dullahanBiomes, dullahanBiomeDictionary);
            List<String> dwarfBiomes = GaiaSpawningConfig.generateList(Biomes.f_186754_, Biomes.f_186765_, Biomes.f_186766_);
            List<String> dwarfBiomeDictionary = List.of("OVERWORLD,PLATEAU,!COLD,!HOT,!DENSE", "OVERWORLD,MOUNTAIN,!HOT,!DENSE");
            this.dwarfSpawning = new SpawningInfo(builder, "Dwarf", 30, 4, 6, dwarfBiomes, dwarfBiomeDictionary);
            List<String> enderEyeBiomeDictionary = List.of("OVERWORLD");
            this.enderEyeSpawning = new SpawningInfo(builder, "EnderEye", 40, 2, 4, List.of(), enderEyeBiomeDictionary, true);
            List<String> enderDragonGirlBiomeDictionary = List.of("END,COLD,DRY");
            this.enderDragonGirlSpawning = new SpawningInfo(builder, "EnderDragonGirl", 1, 1, 1, List.of(), enderDragonGirlBiomeDictionary, true);
            List<String> fleshLichBiomeDictionary = List.of("OVERWORLD");
            this.fleshLichSpawning = new SpawningInfo(builder, "FleshLich", 40, 1, 2, List.of(), fleshLichBiomeDictionary);
            List<String> gelatinousSlimeBiomes = GaiaSpawningConfig.generateList(Biomes.f_48207_);
            List<String> gelatinousSlimeBiomeDictionary = List.of("OVERWORLD,SWAMP");
            this.gelatinousSlimeSpawning = new SpawningInfo(builder, "GelatinousSlime", 80, 1, 2, gelatinousSlimeBiomes, gelatinousSlimeBiomeDictionary);
            List<String> goblinBiomes = GaiaSpawningConfig.generateList(Biomes.f_48157_);
            List<String> goblinBiomeDictionary = List.of("OVERWORLD,SAVANNA");
            this.goblinSpawning = new SpawningInfo(builder, "Goblin", 30, 2, 6, goblinBiomes, goblinBiomeDictionary);
            List<String> gryphonBiomes = GaiaSpawningConfig.generateList(Biomes.f_186754_, Biomes.f_186765_, Biomes.f_186766_);
            List<String> gryphonBiomeDictionary = List.of("OVERWORLD,PLATEAU,!COLD,!HOT,!DENSE", "OVERWORLD,MOUNTAIN,!HOT,!DENSE");
            this.gryphonSpawning = new SpawningInfo(builder, "Gryphon", 80, 1, 2, gryphonBiomes, gryphonBiomeDictionary);
            List<String> harpyBiomes = GaiaSpawningConfig.generateList(Biomes.f_48202_, Biomes.f_48176_);
            List<String> harpyBiomeDictionary = List.of("OVERWORLD,PLAINS,!SAVANNA", "OVERWORLD,MESA", "OVERWORLD,FOREST,SPOOKY");
            this.harpySpawning = new SpawningInfo(builder, "Harpy", 100, 2, 4, harpyBiomes, harpyBiomeDictionary);
            List<String> hunterBiomes = GaiaSpawningConfig.generateList(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_48197_);
            List<String> hunterBiomeDictionary = List.of("OVERWORLD,JUNGLE");
            this.hunterSpawning = new SpawningInfo(builder, "Hunter", 60, 2, 4, hunterBiomes, hunterBiomeDictionary);
            List<String> koboldBiomes = GaiaSpawningConfig.generateList(Biomes.f_186761_, Biomes.f_186756_);
            List<String> koboldBiomeDictionary = List.of("OVERWORLD,SNOWY,!OCEAN,!RIVER,!BEACH,!FOREST");
            this.koboldSpawning = new SpawningInfo(builder, "Kobold", 60, 4, 6, koboldBiomes, koboldBiomeDictionary);
            List<String> matangoBiomes = GaiaSpawningConfig.generateList(Biomes.f_48151_);
            List<String> matangoBiomeDictionary = List.of("OVERWORLD,FOREST,SPOOKY");
            this.matangoSpawning = new SpawningInfo(builder, "Matango", 60, 2, 4, matangoBiomes, matangoBiomeDictionary);
            List<String> mermaidBiomes = GaiaSpawningConfig.generateList(Biomes.f_48217_, Biomes.f_48174_, Biomes.f_48166_, Biomes.f_48208_);
            List<String> mermaidBiomeDictionary = List.of("OVERWORLD,BEACH", "OVERWORLD,WATER");
            this.mermaidSpawning = new SpawningInfo(builder, "Mermaid", 40, 2, 4, mermaidBiomes, mermaidBiomeDictionary);
            List<String> minotaurBiomes = GaiaSpawningConfig.generateList(Biomes.f_48202_, Biomes.f_48176_);
            List<String> minotaurBiomeDictionary = List.of("OVERWORLD,PLAINS,!SAVANNA", "OVERWORLD,MESA", "OVERWORLD,FOREST,SPOOKY");
            this.minotaurSpawning = new SpawningInfo(builder, "Minotaur", 10, 1, 1, minotaurBiomes, minotaurBiomeDictionary);
            List<String> minotaurusBiomes = GaiaSpawningConfig.generateList(Biomes.f_48202_, Biomes.f_48176_);
            List<String> minotaurusBiomeDictionary = List.of("OVERWORLD,PLAINS,!SAVANNA", "OVERWORLD,MESA", "OVERWORLD,FOREST,SPOOKY");
            this.minotaurusSpawning = new SpawningInfo(builder, "Minotaurus", 80, 2, 4, minotaurusBiomes, minotaurusBiomeDictionary);
            List<String> mummyBiomes = GaiaSpawningConfig.generateList(Biomes.f_48203_);
            List<String> mummyBiomeDictionary = List.of("OVERWORLD,SANDY,!MESA");
            this.mummySpawning = new SpawningInfo(builder, "Mummy", 100, 2, 4, mummyBiomes, mummyBiomeDictionary);
            List<String> mimicBiomeDictionary = List.of("OVERWORLD");
            this.mimicSpawning = new SpawningInfo(builder, "Mimic", 40, 1, 1, List.of(), mimicBiomeDictionary, true);
            List<String> nagaBiomes = GaiaSpawningConfig.generateList(Biomes.f_48207_);
            List<String> nagaBiomeDictionary = List.of("OVERWORLD,SWAMP");
            this.nagaSpawning = new SpawningInfo(builder, "Naga", 30, 1, 2, nagaBiomes, nagaBiomeDictionary);
            List<String> nineTailsBiomes = GaiaSpawningConfig.generateList(Biomes.f_48152_, Biomes.f_186763_, Biomes.f_186764_);
            List<String> nineTailsBiomeDictionary = List.of("OVERWORLD,FOREST,CONIFEROUS,!SNOWY");
            this.nineTailsSpawning = new SpawningInfo(builder, "NineTails", 40, 2, 4, nineTailsBiomes, nineTailsBiomeDictionary);
            List<String> oniBiomes = GaiaSpawningConfig.generateList(Biomes.f_48152_, Biomes.f_186763_, Biomes.f_186764_);
            List<String> oniBiomeDictionary = List.of("OVERWORLD,FOREST,CONIFEROUS,!SNOWY");
            this.oniSpawning = new SpawningInfo(builder, "Oni", 80, 4, 6, oniBiomes, oniBiomeDictionary);
            List<String> orcBiomes = GaiaSpawningConfig.generateList(Biomes.f_48157_);
            List<String> orcBiomeDictionary = List.of("OVERWORLD,SAVANNA");
            this.orcSpawning = new SpawningInfo(builder, "Orc", 80, 2, 6, orcBiomes, orcBiomeDictionary);
            List<String> satyressBiomes = GaiaSpawningConfig.generateList(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48159_, Biomes.f_48194_);
            List<String> satyressBiomeDictionary = List.of("OVERWORLD,PLAINS,!SAVANNA", "OVERWORLD,MESA");
            this.satyressSpawning = new SpawningInfo(builder, "Satyress", 20, 2, 4, satyressBiomes, satyressBiomeDictionary);
            List<String> shamanBiomes = GaiaSpawningConfig.generateList(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_48197_);
            List<String> shamanBiomeDictionary = List.of("OVERWORLD,JUNGLE");
            this.shamanSpawning = new SpawningInfo(builder, "Shaman", 60, 2, 4, shamanBiomes, shamanBiomeDictionary);
            List<String> sharkoBiomes = GaiaSpawningConfig.generateList(Biomes.f_48217_, Biomes.f_48174_, Biomes.f_48166_, Biomes.f_48208_);
            List<String> sharkoBiomeDictionary = List.of("OVERWORLD,BEACH", "OVERWORLD,WATER");
            this.sharkoSpawning = new SpawningInfo(builder, "Sharko", 40, 2, 4, sharkoBiomes, sharkoBiomeDictionary);
            List<String> sirenBiomes = GaiaSpawningConfig.generateList(Biomes.f_48207_);
            List<String> sirenBiomeDictionary = List.of("OVERWORLD,SWAMP");
            this.sirenSpawning = new SpawningInfo(builder, "Siren", 60, 4, 6, sirenBiomes, sirenBiomeDictionary);
            List<String> sludgeGirlBiomes = GaiaSpawningConfig.generateList(Biomes.f_48207_);
            List<String> sludgeBiomeDictionary = List.of("OVERWORLD,SWAMP");
            this.sludgeGirlSpawning = new SpawningInfo(builder, "SludgeGirl", 100, 2, 4, sludgeGirlBiomes, sludgeBiomeDictionary);
            List<String> sphinxBiomes = GaiaSpawningConfig.generateList(Biomes.f_48203_);
            List<String> sphinxBiomeDictionary = List.of("OVERWORLD,SANDY,!MESA");
            this.sphinxSpawning = new SpawningInfo(builder, "Sphinx", 10, 1, 1, sphinxBiomes, sphinxBiomeDictionary);
            List<String> sprigganBiomes = GaiaSpawningConfig.generateList(Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
            List<String> sprigganBiomeDictionary = List.of("OVERWORLD,FOREST,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY,!DENSE", "OVERWORLD,FOREST,DENSE,RARE,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY");
            this.sprigganSpawning = new SpawningInfo(builder, "Spriggan", 40, 2, 4, sprigganBiomes, sprigganBiomeDictionary);
            List<String> succubusBiomes = GaiaSpawningConfig.generateList(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48200_, Biomes.f_48201_, Biomes.f_48175_);
            List<String> succubusBiomeDictionary = List.of("NETHER");
            this.succubusSpawning = new SpawningInfo(builder, "Succubus", 16, 2, 4, succubusBiomes, succubusBiomeDictionary);
            List<String> toadBiomes = GaiaSpawningConfig.generateList(Biomes.f_48151_);
            List<String> toadBiomeDictionary = List.of("OVERWORLD,FOREST,SPOOKY");
            this.toadSpawning = new SpawningInfo(builder, "Toad", 80, 2, 4, toadBiomes, toadBiomeDictionary);
            List<String> valkyrieBiomes = GaiaSpawningConfig.generateList(Biomes.f_186754_, Biomes.f_186765_, Biomes.f_186766_);
            List<String> valkyrieBiomeDictionary = List.of("OVERWORLD,PLATEAU,!COLD,!HOT,!DENSE", "OVERWORLD,MOUNTAIN,!HOT,!DENSE");
            this.valkyrieSpawning = new SpawningInfo(builder, "Valkyrie", 10, 1, 2, valkyrieBiomes, valkyrieBiomeDictionary);
            List<String> werecatBiomes = GaiaSpawningConfig.generateList(Biomes.f_48205_, Biomes.f_48149_, Biomes.f_186762_);
            List<String> werecatBiomeDictionary = List.of("OVERWORLD,FOREST,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY,!DENSE", "OVERWORLD,FOREST,DENSE,RARE,!CONIFEROUS,!COLD,!HOT,!SPARSE,!SPOOKY");
            this.werecatSpawning = new SpawningInfo(builder, "Werecat", 80, 4, 6, werecatBiomes, werecatBiomeDictionary);
            List<String> witchBiomes = GaiaSpawningConfig.generateList(Biomes.f_48151_);
            List<String> witchBiomeDictionary = List.of("OVERWORLD,FOREST,SPOOKY");
            this.witchSpawning = new SpawningInfo(builder, "Witch", 60, 2, 4, witchBiomes, witchBiomeDictionary);
            List<String> witherCowBiomes = GaiaSpawningConfig.generateList(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48200_, Biomes.f_48201_, Biomes.f_48175_);
            List<String> witherCowBiomeDictionary = List.of("NETHER");
            this.witherCowSpawning = new SpawningInfo(builder, "WitherCow", 12, 2, 4, witherCowBiomes, witherCowBiomeDictionary);
            List<String> wizardHarpyBiomes = GaiaSpawningConfig.generateList(Biomes.f_48151_);
            List<String> wizardHarpyBiomeDictionary = List.of("OVERWORLD,FOREST,SPOOKY");
            this.wizardHarpySpawning = new SpawningInfo(builder, "WizardHarpy", 60, 1, 2, wizardHarpyBiomes, wizardHarpyBiomeDictionary);
            List<String> yukiOnnaBiomes = GaiaSpawningConfig.generateList(Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186763_, Biomes.f_186764_);
            List<String> yukiOnnaBiomeDictionary = List.of("OVERWORLD,FOREST,CONIFEROUS,!SNOWY");
            this.yukiOnnaSpawning = new SpawningInfo(builder, "YukiOnna", 60, 2, 4, yukiOnnaBiomes, yukiOnnaBiomeDictionary);
            builder.pop();
        }
    }
}

