/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.client;

import gaia.item.MerchantSpawnItem;
import gaia.registry.GaiaRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class GaiaItemModels
extends ItemModelProvider {
    public GaiaItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "grimoireofgaia", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject item : GaiaRegistry.ITEMS.getEntries()) {
            if (item.get() instanceof MerchantSpawnItem) {
                this.spawnItem((Item)item.get());
                continue;
            }
            if (!(item.get() instanceof ForgeSpawnEggItem)) continue;
            this.withExistingParent(((Item)item.get()).getRegistryName().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
        }
        this.withBlockParent((Block)GaiaRegistry.BUST_GORGON.get());
        this.withBlockParent((Block)GaiaRegistry.BUST_MINOTAUR.get());
        this.withBlockParent((Block)GaiaRegistry.BUST_SPHINX.get());
        this.withBlockParent((Block)GaiaRegistry.BUST_VALKYRIE.get());
        this.withBlockParent((Block)GaiaRegistry.BUST_VAMPIRE.get());
        this.withBlockParent((Block)GaiaRegistry.DECO_GARDEN_GNOME.get());
        this.withBlockParent((Block)GaiaRegistry.DECO_MANDRAGORA_POT.get());
        this.withBlockParent((Block)GaiaRegistry.DECO_NEST_HARPY.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_CREEPER_GIRL.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_DRYAD.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_DULLAHAN.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_ENDER_GIRL.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_MAID.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_MERMAID.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_NINE_TAILS.get());
        this.withBlockParent((Block)GaiaRegistry.DOLL_SLIME_GIRL.get());
        this.withBlockParent((Block)GaiaRegistry.PEARL_BLOCK.get());
        this.generatedItem((Item)GaiaRegistry.BOOK_OF_MEMORY.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_FREEZING.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_METAL.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_ENDER.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_HUNGER.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_NATURE.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_WITHER.get());
        this.generatedBook((Item)GaiaRegistry.WEAPON_BOOK_BUFF.get());
        this.handheldItem((Item)GaiaRegistry.CURSED_METAL_SWORD.get(), "weapon");
        this.handheldItem((Item)GaiaRegistry.METAL_CLUB.get(), "weapon");
        this.generatedItem((Item)GaiaRegistry.EXPERIENCE_IRON.get());
        this.generatedItem((Item)GaiaRegistry.EXPERIENCE_GOLD.get());
        this.generatedItem((Item)GaiaRegistry.EXPERIENCE_DIAMOND.get());
        this.generatedItem((Item)GaiaRegistry.ELYTRA_FRAGMENT.get());
        this.generatedItem((Item)GaiaRegistry.TOTEM_FRAGMENT.get());
        this.generatedItem((Item)GaiaRegistry.DIAMOND_SHARD.get());
        this.generatedItem((Item)GaiaRegistry.EMERALD_SHARD.get());
        this.generatedItem((Item)GaiaRegistry.SHINY_PEARL.get());
        this.generatedItem((Item)GaiaRegistry.FIRESHARD.get());
        this.generatedItem((Item)GaiaRegistry.FUR.get());
        this.generatedItem((Item)GaiaRegistry.GIGA_GEAR.get());
        this.generatedItem((Item)GaiaRegistry.GOLDEN_APPLE_PIE.get());
        this.generatedItem((Item)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get());
        this.generatedItem((Item)GaiaRegistry.MANDRAKE.get());
        this.generatedItem((Item)GaiaRegistry.HONEYDEW.get());
        this.generatedItem((Item)GaiaRegistry.KNUCKLES.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.RING_OF_SPEED.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.RING_OF_HASTE.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.RING_OF_JUMP.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.RING_OF_NIGHT.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.HEAVY_BARBELL.get(), "accessory");
        this.generatedItem((Item)GaiaRegistry.MEAT.get());
        this.generatedItem((Item)GaiaRegistry.MONSTER_FEED.get());
        this.generatedItem((Item)GaiaRegistry.PREMIUM_MONSTER_FEED.get());
        this.handheldItem((Item)GaiaRegistry.METAL_DAGGER.get(), "weapon");
        this.generatedItem((Item)GaiaRegistry.QUILL.get());
        this.generatedItem((Item)GaiaRegistry.ROTTEN_HEART.get());
        this.generatedItem((Item)GaiaRegistry.SOULFIRE.get());
        this.generatedItem((Item)GaiaRegistry.STONE_COAL.get());
        this.generatedItem((Item)GaiaRegistry.TAPROOT.get());
        this.handheldItem((Item)GaiaRegistry.ZOMBIE_STAFF.get(), "weapon", "summoning_staff");
        this.handheldItem((Item)GaiaRegistry.SKELETON_STAFF.get(), "weapon", "summoning_staff");
        this.handheldItem((Item)GaiaRegistry.CAVE_SPIDER_STAFF.get(), "weapon", "summoning_staff");
        this.handheldItem((Item)GaiaRegistry.MAGIC_STAFF.get(), "weapon", "summoning_staff");
        this.parentItem((Item)GaiaRegistry.FAN_FIRE.get(), this.modLoc("item/fan"), "weapon/fan");
        this.parentItem((Item)GaiaRegistry.FAN_ICE.get(), this.modLoc("item/fan"), "weapon/fan");
        this.generatedItem((Item)GaiaRegistry.NETHER_WART_JAM.get());
        this.generatedItem((Item)GaiaRegistry.WITHERED_BRAIN.get());
        this.generatedBox((Item)GaiaRegistry.BOX_DIAMOND.get());
        this.generatedBox((Item)GaiaRegistry.BOX_END.get());
        this.generatedBox((Item)GaiaRegistry.BOX_GOLD.get());
        this.generatedBox((Item)GaiaRegistry.BOX_IRON.get());
        this.generatedBox((Item)GaiaRegistry.BOX_NETHER.get());
        this.generatedBox((Item)GaiaRegistry.BOX_OVERWORLD.get());
        this.generatedBox((Item)GaiaRegistry.CHEST_DESERT.get());
        this.generatedBox((Item)GaiaRegistry.CHEST_DUNGEON.get());
        this.generatedBox((Item)GaiaRegistry.CHEST_JUNGLE.get());
        this.generatedItem((Item)GaiaRegistry.BAG_ARROWS.get(), "bag");
        this.generatedItem((Item)GaiaRegistry.BAG_BOOK.get(), "bag");
        this.generatedItem((Item)GaiaRegistry.BAG_RECORD.get(), "bag");
        this.generatedItem((Item)GaiaRegistry.BOX_HAT.get(), "box");
        this.generatedItem((Item)GaiaRegistry.BOX_OLD.get(), "box");
        this.generatedItem((Item)GaiaRegistry.BOX_EGG.get(), "spawn");
        this.generatedItem((Item)GaiaRegistry.TRADER_TOKEN.get());
        this.generatedItem((Item)GaiaRegistry.HOLSTAURUS_TOKEN.get());
        this.generatedItem((Item)GaiaRegistry.WERESHEEP_TOKEN.get());
    }

    private void withBlockParent(Block block) {
        ResourceLocation location = block.getRegistryName();
        this.withExistingParent(location.m_135815_(), this.modLoc("block/" + location.m_135815_()));
    }

    private void generatedItem(Item item) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("grimoireofgaia", "item/" + location.m_135815_()));
    }

    private void spawnItem(Item item) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("grimoireofgaia", "item/spawn/" + location.m_135815_()));
    }

    private void handheldItem(Item item, String subFolder) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/handheld"), "layer0", new ResourceLocation("grimoireofgaia", "item/" + subFolder + "/" + location.m_135815_()));
    }

    private void handheldItem(Item item, String subFolder, String textureName) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/handheld"), "layer0", new ResourceLocation("grimoireofgaia", "item/" + subFolder + "/" + textureName));
    }

    private void generatedItem(Item item, String subFolder) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("grimoireofgaia", "item/" + subFolder + "/" + location.m_135815_()));
    }

    private void parentItem(Item item, ResourceLocation parent, String subFolder) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), parent, "0", new ResourceLocation("grimoireofgaia", "item/" + subFolder + "/" + location.m_135815_()));
    }

    private void generatedBox(Item item) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("grimoireofgaia", "item/chest"), "0", new ResourceLocation("grimoireofgaia", "item/box/" + location.m_135815_()));
    }

    private void generatedBook(Item item) {
        ResourceLocation location = item.getRegistryName();
        this.singleTexture(location.m_135815_(), new ResourceLocation("grimoireofgaia", "item/weapon_book"), "0", new ResourceLocation("grimoireofgaia", "item/weapon/book/" + location.m_135815_()));
    }
}

