/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.client;

import gaia.datagen.client.helper.MobSoundHelper;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.registry.helper.MobReg;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;

public class GaiaSoundProvider
extends SoundDefinitionsProvider {
    public GaiaSoundProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "grimoireofgaia", helper);
    }

    public void registerSounds() {
        this.add((Supplier)GaiaSounds.BAG_OPEN, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BAG_OPEN.getId())).with(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/bag_open"))));
        this.add((Supplier)GaiaSounds.BOOK_HIT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BOOK_HIT.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/book_hit1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/book_hit2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/book_hit3")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/book_hit4"))}));
        this.add((Supplier)GaiaSounds.METAL_BOOK_HIT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BOOK_HIT.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone4")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone5")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("step/stone6"))}));
        this.add((Supplier)GaiaSounds.BOX_OPEN, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BOX_OPEN.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/box_open1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("item/box_open2"))}));
        this.add((Supplier)GaiaSounds.CREEP_PRIMED, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.CREEP_PRIMED.getId())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("random/fuse"))));
        this.add((Supplier)GaiaSounds.GOBLIN_FERAL_PRIMED, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.GOBLIN_FERAL_PRIMED.getId())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("random/fuse"))));
        this.add((Supplier)GaiaSounds.GAIA_SHOOT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.GAIA_SHOOT.getId())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/ghast/fireball4"))));
        this.add((Supplier)GaiaSounds.BOMB_THROW, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BOMB_THROW.getId())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/ghast/fireball4"))));
        this.add((Supplier)GaiaSounds.MANDRAGORA_SCREAM, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.MANDRAGORA_SCREAM.getId())).with(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/mandragora/scream"))));
        this.add((Supplier)GaiaSounds.ANT_HILL_DEATH, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.ANT_HILL_DEATH.getId())).with(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none"))));
        this.add((Supplier)GaiaSounds.ENDER_EYE_SCREAM, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.ENDER_EYE_SCREAM.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream4"))}));
        this.add((Supplier)GaiaSounds.ENDER_EYE_TELEPORT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.ENDER_EYE_TELEPORT.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal2"))}));
        this.add((Supplier)GaiaSounds.ENDER_DRAGON_GIRL_SCREAM, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.ENDER_DRAGON_GIRL_SCREAM.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream4"))}));
        this.add((Supplier)GaiaSounds.ENDER_DRAGON_GIRL_TELEPORT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.ENDER_DRAGON_GIRL_TELEPORT.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal2"))}));
        this.add((Supplier)GaiaSounds.BEHENDER_SCREAM, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BEHENDER_SCREAM.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/scream4"))}));
        this.add((Supplier)GaiaSounds.BEHENDER_TELEPORT, GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaSounds.BEHENDER_TELEPORT.getId())).with(new SoundDefinition.Sound[]{GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/portal2"))}));
        this.generateMobSound();
        this.add(GaiaRegistry.COBBLE_GOLEM.getAttack(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaRegistry.COBBLE_GOLEM.getAttack().m_11660_())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/throw"))));
        this.add(GaiaRegistry.COBBLESTONE_GOLEM.getAttack(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(GaiaRegistry.COBBLESTONE_GOLEM.getAttack().m_11660_())).with(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/throw"))));
    }

    public void generateMobSound() {
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ANT_WORKER).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ANT_SALVAGER).withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/ant_salvager/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/ant_salvager/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/ant_salvager/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/ant_salvager/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/ant_salvager/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ANUBIS).withDefaults().withSayMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/say2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/say3"))).withHurtMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/hurt2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/hurt3"))).withDeathMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/anubis_male/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ARACHNE).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.BANSHEE).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.BEE).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/say2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/say3")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/say4")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/say5"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/hurt2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/hurt3"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/death1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/bee/death2"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.BEHENDER).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle4")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle5"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.BONE_KNIGHT).withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/say1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/say2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/say3"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/hurt1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/hurt2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/hurt3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/hurt4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/death"))).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/step1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/step2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/step3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/skeleton/step4"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.CECAELIA).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.CENTAUR).withDefaults().withSayMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/say2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/say3"))).withHurtMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/hurt2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/hurt3"))).withDeathMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/centaur_male/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.CYCLOPS).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.CREEP).withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/creeper/say1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/creeper/say2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/creeper/say3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/creeper/say4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/creeper/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.COBBLE_GOLEM).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.COBBLESTONE_GOLEM).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.DRYAD).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.DULLAHAN).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.DWARF).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/dwarf/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/dwarf/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/dwarf/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/dwarf/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/dwarf/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ENDER_EYE).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle4")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle5"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ENDER_DRAGON_GIRL).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle4")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/idle5"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/hit4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/endermen/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.FLESH_LICH).withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/say1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/say2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/say3"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/hurt1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/death"))).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/step1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/step2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/step3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/step4")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/zombie/step5"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.GELATINOUS_SLIME).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.GOBLIN).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/goblin/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/goblin/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/goblin/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/goblin/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/goblin/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.GOBLIN_FERAL).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.GRYPHON).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/gryphon/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/gryphon/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/gryphon/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/gryphon/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/gryphon/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.HARPY).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.HUNTER).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.HORSE).withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/idle1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/idle2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/idle3"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/hit1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/hit2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/hit3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/hit4"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/horse/zombie/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.KOBOLD).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MANDRAGORA).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MATANGO).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MERMAID).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MINOTAUR).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/minotaur/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/minotaur/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/minotaur/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/minotaur/hurt2"))).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/irongolem/walk4"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MINOTAURUS).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.GRAVEMITE).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/say1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/say2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/say3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/say4"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/hit1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/hit2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/hit3"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/kill"))).withStep(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/step1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/step2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/step3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/silverfish/step4"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.MUMMY).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.NAGA).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/naga/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/naga/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/naga/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/naga/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/naga/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.NINE_TAILS).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ONI).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ORC).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/orc/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/orc/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/orc/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/orc/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/orc/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SATYRESS).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SHAMAN).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SHARKO).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/sharko/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/sharko/say2"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/sharko/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/sharko/hurt2"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/sharko/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SIREN).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SLUDGE_GIRL).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SPHINX).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SPORELING).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SPRIGGAN).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SUCCUBUS).withDefaults().withSayMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/say1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/say2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/say3"))).withHurtMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/hurt1")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/hurt2")), GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/hurt3"))).withDeathMale(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/succubus_male/death"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.TOAD).withDefaults().withSay(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("entity/toad/say1"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.VALKYRIE).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.WERECAT).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.WITCH).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.WITHER_COW).withSay(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/say1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/say2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/say3")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/say4"))).withHurt(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt3"))).withDeath(GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt1")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt2")), GaiaSoundProvider.sound((ResourceLocation)new ResourceLocation("mob/cow/hurt3"))).build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.WIZARD_HARPY).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.YUKI_ONNA).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.TRADER).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.CREEPER_GIRL).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.ENDER_GIRL).withDefaults().build());
        this.setupMobSounds(new MobSoundHelper.Builder(GaiaRegistry.SLIME_GIRL).withDefaults().build());
    }

    public void setupMobSounds(MobSoundHelper helper) {
        List<SoundDefinition.Sound> sounds;
        MobReg<?> mobReg = helper.getMobReg();
        if (mobReg.getSay() != null) {
            sounds = helper.getSay().length > 0 ? List.of(helper.getSay()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
            this.add(mobReg.getSay(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getSay().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
        }
        if (mobReg.getHurt() != null) {
            sounds = helper.getHurt().length > 0 ? List.of(helper.getHurt()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
            this.add(mobReg.getHurt(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getHurt().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
        }
        if (mobReg.getDeath() != null) {
            sounds = helper.getDeath().length > 0 ? List.of(helper.getDeath()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
            this.add(mobReg.getDeath(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getDeath().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
        }
        if (mobReg.getStep() != null) {
            sounds = helper.getStep().length > 0 ? List.of(helper.getStep()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
            this.add(mobReg.getStep(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getStep().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
        }
        if (mobReg.hasGender()) {
            if (mobReg.getMaleSay() != null) {
                sounds = helper.getMaleSay().length > 0 ? List.of(helper.getMaleSay()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
                this.add(mobReg.getMaleSay(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getMaleSay().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
            }
            if (mobReg.getMaleHurt() != null) {
                sounds = helper.getMaleHurt().length > 0 ? List.of(helper.getMaleHurt()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
                this.add(mobReg.getMaleHurt(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getMaleHurt().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
            }
            if (mobReg.getMaleDeath() != null) {
                sounds = helper.getMaleDeath().length > 0 ? List.of(helper.getMaleDeath()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
                this.add(mobReg.getMaleDeath(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getMaleDeath().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
            }
            if (mobReg.getMaleStep() != null) {
                sounds = helper.getMaleStep().length > 0 ? List.of(helper.getMaleStep()) : List.of(GaiaSoundProvider.sound((ResourceLocation)this.modLoc("none")));
                this.add(mobReg.getMaleStep(), GaiaSoundProvider.definition().subtitle(this.modSubtitle(mobReg.getMaleStep().m_11660_())).with(sounds.toArray(new SoundDefinition.Sound[0])));
            }
        }
    }

    public String modSubtitle(ResourceLocation id) {
        return "grimoireofgaia.subtitle." + id.m_135815_();
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation("grimoireofgaia", name);
    }
}

