/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class GaiaLoot
extends LootTableProvider {
    public GaiaLoot(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(GaiaBlockTables::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(GaiaEntityLoot::new, (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        List<ResourceLocation> ignored = List.of(GaiaLootTables.CHEST_TABLES, GaiaRegistry.CHEST.getEntityType().m_20677_(), GaiaRegistry.HORSE.getEntityType().m_20677_(), GaiaRegistry.MIMIC.getEntityType().m_20677_(), GaiaRegistry.NAGA.getEntityType().m_20677_(), GaiaRegistry.SIREN.getEntityType().m_20677_());
        map.forEach((name, table) -> {
            if (!ignored.contains(name)) {
                LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table);
            }
        });
    }

    private static class GaiaEntityLoot
    extends EntityLoot {
        private GaiaEntityLoot() {
        }

        protected void addTables() {
            this.m_124371_(GaiaRegistry.ANT_HILL.getEntityType(), LootTable.m_79147_());
            this.m_124371_(GaiaRegistry.ANT_WORKER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42496_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HONEYDEW.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ANT_SALVAGER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_5577_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44982_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ANUBIS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ARACHNE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.STONE_COAL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.BANSHEE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.BEE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HONEYDEW.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.BEHENDER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_END.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.BONE_KNIGHT.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42678_).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.CECAELIA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.25f, (float)0.01f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_5577_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44953_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.CENTAUR.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.CHEST.getEntityType(), LootTable.m_79147_());
            this.m_124380_(GaiaLootTables.CHEST_TABLES, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78742_))));
            this.m_124371_(GaiaRegistry.COBBLE_GOLEM.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.COBBLESTONE_GOLEM.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CHEST_JUNGLE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TOTEM_FRAGMENT.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.CREEP.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_CREEPER_GIRL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.CYAN_FLOWER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41939_).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41940_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MANDRAKE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.0625f, (float)0.01f))).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_SHOVELS).m_45077_()).m_32207_()))))));
            this.m_124371_(GaiaRegistry.CYCLOPS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_5577_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44977_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.KNUCKLES.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.DEATHWORD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.DRYAD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)ItemTags.f_13181_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_AXES).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_DRYAD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.DULLAHAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_DULLAHAN.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.DWARF.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_124380_(GaiaLootTables.DWARF_RANGED, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124380_(GaiaLootTables.DWARF_MINER, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_124371_(GaiaRegistry.ENDER_EYE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_ENDER_GIRL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ENDER_DRAGON_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_END.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_ENDER_GIRL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ELYTRA_FRAGMENT.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.FLESH_LICH.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.GEMS_LAPIS).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42681_).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.GELATINOUS_SLIME.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_SLIME_GIRL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.GOBLIN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.GOBLIN_FERAL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))));
            this.m_124371_(GaiaRegistry.GRYPHON.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.HARPY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_NEST_HARPY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.HUNTER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ROTTEN_HEART.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.KOBOLD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.MANDRAGORA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MANDRAKE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_SHOVELS).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_GARDEN_GNOME.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.MATANGO.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.MUSHROOMS).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.MERMAID.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42695_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OLD.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_MERMAID.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SEASHELL_HAIRPIN.get())))));
            this.m_124371_(GaiaRegistry.MINOTAUR.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_MINOTAUR_ITEM.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEAVY_BARBELL.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_HASTE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.MINOTAURUS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get())))));
            this.m_124380_(GaiaLootTables.MINOTAURUS_RANGED, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())))));
            this.m_124371_(GaiaRegistry.MIMIC.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20558_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20479_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20566_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20526_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20501_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20524_.m_20677_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.PREMIUM_MONSTER_FEED.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_RECORD.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.GRAVEMITE.getEntityType(), LootTable.m_79147_());
            this.m_124371_(GaiaRegistry.MUMMY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.NAGA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78723_).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_124371_(GaiaRegistry.NINE_TAILS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FAN_FIRE.get())).m_5577_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44981_, (NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_165374_(Enchantments.f_44980_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_NINE_TAILS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ONI.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_5577_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44977_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.ORC.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_124371_(GaiaRegistry.SATYRESS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SHAMAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ROTTEN_HEART.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SHARKO.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42695_).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.25f, (float)0.01f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_BUFF.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SIREN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78723_).m_5577_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_124366_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SLUDGE_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SPHINX.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_SPHINX.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_JUMP.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CHEST_DESERT.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SPORELING.getEntityType(), LootTable.m_79147_());
            this.m_124371_(GaiaRegistry.SPRIGGAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41837_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_6509_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_AXES).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.SUCCUBUS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FIRESHARD.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_NETHER.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.TOAD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.VALKYRIE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_VALKYRIE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_SPEED.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.WERECAT.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.WITCH.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.NETHER_WART_JAM.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_MANDRAGORA_POT.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.WITHER_COW.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WITHERED_BRAIN.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_NETHER.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.WIZARD_HARPY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.YUKI_ONNA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FAN_ICE.get())).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_124371_(GaiaRegistry.HORSE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20502_.m_20677_()))));
            this.m_124371_(GaiaRegistry.TRADER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get())))));
            this.m_124371_(GaiaRegistry.CREEPER_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get())))));
            this.m_124371_(GaiaRegistry.ENDER_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get())))));
            this.m_124371_(GaiaRegistry.SLIME_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get())))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            Stream<EntityType> entities = GaiaRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get);
            return entities::iterator;
        }
    }

    public static class GaiaBlockTables
    extends BlockLoot {
        protected void addTables() {
            this.m_124288_((Block)GaiaRegistry.BUST_GORGON.get());
            this.m_124288_((Block)GaiaRegistry.BUST_SPHINX.get());
            this.m_124288_((Block)GaiaRegistry.BUST_VALKYRIE.get());
            this.m_124288_((Block)GaiaRegistry.BUST_VAMPIRE.get());
            this.m_124288_((Block)GaiaRegistry.BUST_MINOTAUR.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_CREEPER_GIRL.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_ENDER_GIRL.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_SLIME_GIRL.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_MAID.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_DULLAHAN.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_MERMAID.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_NINE_TAILS.get());
            this.m_124288_((Block)GaiaRegistry.DOLL_DRYAD.get());
            this.m_124288_((Block)GaiaRegistry.DECO_GARDEN_GNOME.get());
            this.m_124288_((Block)GaiaRegistry.DECO_MANDRAGORA_POT.get());
            this.m_124288_((Block)GaiaRegistry.DECO_NEST_HARPY.get());
            this.m_124288_((Block)GaiaRegistry.PEARL_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return GaiaRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
        }
    }
}

