/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.capability.CapabilityHandler;
import gaia.capability.friended.IFriended;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;

public class Bee
extends AbstractAssistGaiaEntity
implements IDayMob,
FlyingAnimal,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(Bee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Bee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int timer;
    private int switchDetect;
    private int switchEquip;
    private boolean animationPlay;
    private int animationTimer;

    public Bee(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader reader) {
        return reader.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setMoving(boolean flag) {
        this.f_19804_.m_135381_(MOVING, (Object)flag);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.poison(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_21223_() >= this.m_21233_()) {
            if (this.detectMovement() && !this.isMoving()) {
                this.setMoving(true);
            }
            if (!this.detectMovement() && this.isMoving()) {
                this.setMoving(false);
            }
        }
        if (this.playerDetection(3, TargetingConditions.m_148352_())) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                this.setGoals(1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                this.setGoals(0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    @Override
    public void onFriendlyChange(IFriended cap) {
        if (cap.isFriendly()) {
            this.setGoals(1);
            this.timer = 0;
            this.switchEquip = 1;
        }
    }

    private boolean detectMovement() {
        BlockState blockstate;
        return this.m_20184_().m_165925_() > 2.500000277905201E-7 && !(blockstate = this.f_19853_.m_8055_(this.m_142538_().m_7495_())).m_60795_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(0, (Goal)this.mobAttackGoal);
        } else {
            this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).ifPresent(cap -> {
                if (!cap.isFriendly()) {
                    this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
                    this.f_21345_.m_25352_(0, (Goal)this.rangedAttackGoal);
                    this.setAnimationState(0);
                    this.animationPlay = false;
                    this.animationTimer = 0;
                }
            });
        }
    }

    private void setCombatTask() {
        this.setGoals(0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.BEE.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.BEE.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.BEE.getDeath();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkBeeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Bee.checkDaysPassed(levelAccessor) && Bee.checkDaytime(levelAccessor) && Bee.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Bee.checkAboveSeaLevel(levelAccessor, pos) && Bee.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

