/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.capability.CapabilityHandler;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.GaiaHorse;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Centaur
extends AbstractAssistGaiaEntity
implements RangedAttackMob,
IDayMob {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.m_135353_(Centaur.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(Centaur.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RangedBowAttackGoal<Centaur> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.275, 20, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.25, 1.3);
    private final AvoidEntityGoal<PathfinderMob> avoidMobGoal = new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 4.0f, 1.25, 1.3);
    private int fullHealth = 0;
    private byte regenerateHealth = 0;

    public Centaur(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MALE, (Object)false);
        this.f_19804_.m_135372_(FLEEING, (Object)false);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(MALE);
    }

    public void setMale(boolean flag) {
        this.f_19804_.m_135381_(MALE, (Object)flag);
    }

    public boolean isFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public void setFleeing(boolean flag) {
        this.f_19804_.m_135381_(FLEEING, (Object)flag);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    @Override
    public void m_8107_() {
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.fullHealth == 0) {
            ItemStack stacky = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43587_);
            this.m_8061_(EquipmentSlot.MAINHAND, stacky);
            this.setGoals(1);
            this.setFleeing(true);
            this.fullHealth = 1;
        }
        if (this.m_21223_() < this.m_21233_() && this.fullHealth == 1) {
            if (this.regenerateHealth <= 100) {
                this.regenerateHealth = (byte)(this.regenerateHealth + 1);
            } else {
                this.m_5496_(SoundEvents.f_11911_, 0.15f, 1.0f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 360, 3));
                this.regenerateHealth = 0;
            }
        } else if (this.m_21223_() >= this.m_21233_() && this.fullHealth == 1) {
            this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).ifPresent(cap -> {
                if (!cap.isFriendly()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    this.setGoals(0);
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                    this.setGoals(2);
                }
            });
            this.m_21195_(MobEffects.f_19605_);
            this.setFleeing(false);
            this.fullHealth = 0;
            this.regenerateHealth = 0;
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        switch (id) {
            default: {
                this.f_21345_.m_25363_(this.avoidPlayerGoal);
                this.f_21345_.m_25363_(this.avoidMobGoal);
                this.f_21345_.m_25352_(1, this.bowAttackGoal);
                break;
            }
            case 1: {
                this.f_21345_.m_25363_(this.bowAttackGoal);
                this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
                this.f_21345_.m_25352_(3, this.avoidPlayerGoal);
                this.f_21345_.m_25352_(3, this.avoidMobGoal);
                break;
            }
            case 2: {
                this.f_21345_.m_25363_(this.avoidPlayerGoal);
                this.f_21345_.m_25363_(this.avoidMobGoal);
                this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
            }
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_(this.bowAttackGoal);
        this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_41720_() instanceof BowItem) {
            int i = 20;
            if (this.f_19853_.m_46791_() != Difficulty.HARD) {
                i = 40;
            }
            this.bowAttackGoal.m_25797_(i);
            this.setGoals(0);
        } else {
            this.setGoals(2);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    public ItemStack m_6298_(ItemStack stack) {
        return super.m_6298_(stack);
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        if (this.f_19796_.nextBoolean()) {
            if (this.f_19796_.nextInt(2) == 0) {
                this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43615_));
            } else {
                this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43593_));
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        GaiaHorse gaiaHorse;
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.nextInt(2) == 0) {
            this.setMale(true);
        }
        if (((Biome)levelAccessor.m_204166_(this.m_142538_()).m_203334_()).m_47505_(this.m_142538_()) > 1.0f) {
            this.setVariant(1);
        }
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        this.setCombatTask();
        if (this.f_19796_.nextInt(10000) == 0 && difficultyInstance.m_19048_() != Difficulty.PEACEFUL && (gaiaHorse = this.createHorse(difficultyInstance)) != null) {
            this.m_20329_((Entity)gaiaHorse);
        }
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Male", this.isMale());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Male")) {
            boolean male = tag.m_128471_("Male");
            this.setMale(male);
        }
        this.setGoals(0);
    }

    protected SoundEvent m_7515_() {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getSay() : GaiaRegistry.CENTAUR.getMaleSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getHurt() : GaiaRegistry.CENTAUR.getMaleHurt();
    }

    protected SoundEvent m_5592_() {
        return !this.isMale() ? GaiaRegistry.CENTAUR.getDeath() : GaiaRegistry.CENTAUR.getMaleDeath();
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkCentaurSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Centaur.checkDaysPassed(levelAccessor) && Centaur.checkDaytime(levelAccessor) && Centaur.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Centaur.checkAboveSeaLevel(levelAccessor, pos) && Centaur.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

