/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class CobbleGolem
extends AbstractAssistGaiaEntity
implements IDayMob {
    private int attackAnimationTick;

    public CobbleGolem(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MobAttackGoal((PathfinderMob)this, 1.15, true));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Player player;
        ItemStack itemstack;
        float input = this.getBaseDamage(source, damage);
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (itemstack = (player = (Player)entity).m_21120_(player.m_7655_())).canPerformAction(ToolActions.PICKAXE_DIG)) {
            input += 5.0f;
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 7.0f + (float)this.f_19796_.nextInt(15));
        if (flag) {
            entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, (double)0.6f, 0.0));
            this.m_19970_((LivingEntity)this, entityIn);
        }
        this.m_5496_(GaiaRegistry.COBBLE_GOLEM.getAttack(), 1.0f, 1.0f);
        return flag;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(GaiaRegistry.COBBLE_GOLEM.getAttack(), 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Override
    public void m_8107_() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_20159_()) {
            this.m_8127_();
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.nextInt(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.nextFloat() - 0.5), 0.5, ((double)this.f_19796_.nextFloat() - 0.5) * 4.0);
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12442_;
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.COBBLE_GOLEM.getDeath();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(GaiaRegistry.COBBLE_GOLEM.getStep(), 1.0f, 1.0f);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && effectInstance.m_19544_() != MobEffects.f_19602_ && super.m_7301_(effectInstance);
    }

    protected float m_6515_(DamageSource source, float damage) {
        damage = super.m_6515_(source, damage);
        if (source.m_7639_() == this) {
            damage = 0.0f;
        }
        if (source.m_19387_()) {
            damage *= 0.15f;
        }
        return damage;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkCobbleGolemSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return CobbleGolem.checkDaysPassed(levelAccessor) && CobbleGolem.checkDaytime(levelAccessor) && CobbleGolem.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && CobbleGolem.checkAboveSeaLevel(levelAccessor, pos) && CobbleGolem.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

