/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.goal.StrafeGoal;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class Deathword
extends AbstractGaiaEntity {
    private static final int DETECTION_RANGE = 6;
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private final StrafeGoal strafeGoal = new StrafeGoal((Mob)this, 1.25, 20, 15.0f);
    private boolean canSpawn;
    private int spawnTimer;
    private int spawnLimit;

    public Deathword(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.canSpawn = true;
        this.spawnTimer = 0;
        this.spawnLimit = 0;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader reader) {
        return reader.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_20159_()) {
            this.m_8127_();
        }
        this.beaconMonster(6, entity -> {
            if (!(entity instanceof Player)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 1, true, true));
            }
        });
        if (this.playerDetection(6, TargetingConditions.m_148353_())) {
            if (this.spawnLimit <= 3 && this.canSpawn) {
                if (this.spawnTimer != 60) {
                    ++this.spawnTimer;
                }
                if (this.spawnTimer == 60) {
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                    if (!this.f_19853_.f_46443_) {
                        switch (this.f_19796_.nextInt(4)) {
                            case 0: {
                                boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this);
                                if (!flag) {
                                    this.setSpawn(0);
                                    break;
                                }
                                this.setSpawn(1);
                                break;
                            }
                            case 1: {
                                this.setSpawn(1);
                                break;
                            }
                            case 2: {
                                this.setSpawn(2);
                                break;
                            }
                            case 3: {
                                this.setSpawn(3);
                                break;
                            }
                        }
                    }
                    this.spawnTimer = 0;
                    ++this.spawnLimit;
                }
            }
            if (this.spawnLimit >= 4 && this.canSpawn) {
                this.setGoals(1);
                this.canSpawn = false;
            }
        }
        Vec3 motion = this.m_20184_();
        if (!this.f_19861_ && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        motion = this.m_20184_();
        if (motion.f_82479_ > 0.0 || motion.f_82480_ > 0.0 || motion.f_82481_ > 0.0) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_6060_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        super.m_8107_();
    }

    private void setSpawn(int id) {
        if (!this.f_19853_.f_46443_) {
            Creeper summon;
            BlockPos blockpos = this.m_142538_().m_142082_(-1 + this.f_19796_.nextInt(3), 1, -1 + this.f_19796_.nextInt(3));
            if (id == 0 && (summon = (Creeper)EntityType.f_20558_.m_20615_(this.f_19853_)) != null) {
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                this.f_19853_.m_7967_((Entity)summon);
            }
            if (id == 1 && (summon = (Skeleton)EntityType.f_20524_.m_20615_(this.f_19853_)) != null) {
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                summon.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.FEET, 0.0f);
                summon.m_21409_(EquipmentSlot.LEGS, 0.0f);
                summon.m_21409_(EquipmentSlot.CHEST, 0.0f);
                summon.m_21409_(EquipmentSlot.HEAD, 0.0f);
                this.f_19853_.m_7967_((Entity)summon);
            }
            if (id == 2 && (summon = (Spider)EntityType.f_20479_.m_20615_(this.f_19853_)) != null) {
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                this.f_19853_.m_7967_((Entity)summon);
            }
            if (id == 3 && (summon = (Zombie)EntityType.f_20501_.m_20615_(this.f_19853_)) != null) {
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                summon.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.FEET, 0.0f);
                summon.m_21409_(EquipmentSlot.LEGS, 0.0f);
                summon.m_21409_(EquipmentSlot.CHEST, 0.0f);
                summon.m_21409_(EquipmentSlot.HEAD, 0.0f);
                this.f_19853_.m_7967_((Entity)summon);
            }
        }
        this.f_19853_.m_7605_((Entity)this, (byte)6);
    }

    private void setGoals(int id) {
        if (id == 0) {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.strafeGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.strafeGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        this.f_21345_.m_25363_((Goal)this.strafeGoal);
        this.setGoals(1);
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.ZOMBIE_STAFF.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)GaiaSounds.BOOK_HIT.get();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkDeathwordSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Deathword.checkDaysPassed(levelAccessor) && Deathword.checkBelowSeaLevel(levelAccessor, pos) && Deathword.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

