/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class GelatinousSlime
extends AbstractGaiaEntity {
    private boolean animationPlay;
    private int animationTimer;
    public float targetSquish;
    public float squish;
    public float oSquish;

    public GelatinousSlime(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.15, true));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth2()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.125).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage2()).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (source.m_7640_() instanceof AbstractArrow) {
            this.f_19853_.m_7605_((Entity)this, (byte)8);
            this.m_5634_(this.m_21233_() * 0.1f);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        if (this.f_19797_ % 60 == 0) {
            this.animationPlay = true;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            this.targetSquish = -0.1f;
            if (this.animationTimer != 10) {
                ++this.animationTimer;
            } else {
                this.targetSquish = 1.0f;
                this.animationPlay = false;
            }
        }
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_20159_()) {
            this.m_8127_();
        }
        this.beaconMonster(4, entity -> {
            if (!(entity instanceof Player)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, true, true));
            }
        });
        if (this.m_21223_() < this.m_21233_() && !this.m_21206_().m_41619_()) {
            this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            this.f_19853_.m_7605_((Entity)this, (byte)8);
            this.m_5634_(this.m_21233_() * 0.2f);
        }
        super.m_8107_();
    }

    protected void m_6153_() {
        if (!this.f_19853_.f_46443_) {
            this.spawnLingeringCloud(List.of(new MobEffectInstance(MobEffects.f_19614_, 40, 0)));
        }
        super.m_6153_();
    }

    protected void m_6851_(DifficultyInstance instance) {
        ItemStack spawnItem = switch (this.f_19796_.nextInt(3)) {
            case 0 -> new ItemStack((ItemLike)Items.f_42411_);
            case 1 -> new ItemStack((ItemLike)Items.f_42412_);
            case 2 -> new ItemStack((ItemLike)Items.f_42425_);
            default -> ItemStack.f_41583_;
        };
        this.m_8061_(EquipmentSlot.OFFHAND, spawnItem);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6851_(difficultyInstance);
        this.m_21553_(true);
        return data;
    }

    protected ResourceLocation m_7582_() {
        if (this.f_19796_.nextBoolean()) {
            return EntityType.f_20524_.m_20677_();
        }
        return super.m_7582_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.GELATINOUS_SLIME.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.GELATINOUS_SLIME.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.GELATINOUS_SLIME.getDeath();
    }

    public boolean m_5825_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkGelatinousSlimeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return GelatinousSlime.checkDaysPassed(levelAccessor) && GelatinousSlime.checkAboveSeaLevel(levelAccessor, pos) && GelatinousSlime.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

