/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class GoblinFeral
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(GoblinFeral.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(GoblinFeral.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RangedBowAttackGoal<GoblinFeral> rangedAttackGoal = new RangedBowAttackGoal((Monster)this, 1.25, 20, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;

    public GoblinFeral(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)((float)SharedEntityData.getMaxHealth1() * 0.5f)).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1() * 0.5).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public float getSwelling(float swell) {
        return Mth.m_14179_((float)swell, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int direction) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)direction);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    @Override
    public int maxVariants() {
        return 2;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.m_21206_().m_41619_() && this.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            return !(source.m_7640_() instanceof AbstractArrow) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (this.getVariant() == 2 && entityIn instanceof LivingEntity) {
            this.ignite();
        }
        return flag;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_((SoundEvent)GaiaSounds.GOBLIN_FERAL_PRIMED.get(), 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explode();
            }
        }
        super.m_8119_();
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius, explosion$blockinteraction);
            this.m_146870_();
        }
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.m_8061_(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
        this.f_21345_.m_25363_(this.rangedAttackGoal);
        if (this.m_21205_().m_41720_() instanceof ProjectileWeaponItem) {
            int i = 20;
            if (this.f_19853_.m_46791_() != Difficulty.HARD) {
                i = 40;
            }
            this.rangedAttackGoal.m_25797_(i);
            this.f_21345_.m_25352_(1, this.rangedAttackGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.collideAttackGoal);
        }
    }

    protected void m_6851_(DifficultyInstance instance) {
        if (this.f_19796_.nextInt(4) == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            this.setVariant(1);
        } else if (this.f_19796_.nextInt(4) == 0) {
            this.setVariant(2);
        } else {
            if (this.f_19796_.nextInt(4) == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                this.m_6850_(instance);
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42423_));
                this.m_6850_(instance);
            }
            this.setVariant(0);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6851_(difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Fuse", (short)this.maxSwell);
        tag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        tag.m_128379_("ignited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Fuse", 99)) {
            this.maxSwell = tag.m_128448_("Fuse");
        }
        if (tag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = tag.m_128445_("ExplosionRadius");
        }
        if (tag.m_128471_("ignited")) {
            this.ignite();
        }
        this.setCombatTask();
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.GOBLIN_FERAL.getEntityType();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.GOBLIN_FERAL.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.GOBLIN_FERAL.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.GOBLIN_FERAL.getDeath();
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkGoblinFeralSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return GoblinFeral.checkDaysPassed(levelAccessor) && GoblinFeral.checkAboveSeaLevel(levelAccessor, pos) && GoblinFeral.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

