/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Mermaid
extends AbstractAssistGaiaEntity {
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private byte inWaterTimer;

    public Mermaid(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new MermaidMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 8.0f);
        this.f_21364_ = 20;
        this.inWaterTimer = 0;
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.275, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth2()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage2()).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_(Attributes.f_22278_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    public float m_20236_(Pose pose) {
        return this.m_6972_((Pose)pose).f_20378_ * 0.5f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (this.hasShield()) {
            return !(source.m_7640_() instanceof AbstractArrow) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 2));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_20069_()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)8);
                this.m_5634_(this.m_21233_() * 0.1f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        super.m_8107_();
    }

    boolean wantsToSwim() {
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_6142_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
        this.m_6850_(instance);
        ItemStack shield = new ItemStack((ItemLike)GaiaRegistry.GOLD_SHIELD.get());
        this.m_8061_(EquipmentSlot.OFFHAND, shield);
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.f_42463_);
        this.m_8061_(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.m_41663_(Enchantments.f_44973_, 3);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.nextInt(4) == 0) {
            this.setVariant(1);
        }
        this.m_6851_(difficultyInstance);
        return data;
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.MERMAID.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.MERMAID.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.MERMAID.getDeath();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    protected int m_6101_() {
        return 10;
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_6914_(LevelReader reader) {
        return reader.m_45784_((Entity)this);
    }

    public static boolean checkMermaidSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        boolean daysPassed = Mermaid.checkDaysPassed(levelAccessor);
        boolean isNight = !Mermaid.checkDaytime(levelAccessor);
        boolean inWater = Mermaid.checkInWater((LevelAccessor)levelAccessor, pos, 5);
        boolean notPeaceful = Mermaid.checkNotPeaceful((LevelAccessor)levelAccessor);
        boolean matchRandom = random.nextInt(15) == 0;
        return daysPassed && isNight && inWater && notPeaceful && matchRandom;
    }

    static class MermaidMoveControl
    extends MoveControl {
        private final Mermaid mermaid;

        public MermaidMoveControl(Mermaid mermaid) {
            super((Mob)mermaid);
            this.mermaid = mermaid;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.mermaid.m_5448_();
            if (this.mermaid.wantsToSwim() && this.mermaid.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.mermaid.m_20186_()) {
                    this.mermaid.m_20256_(this.mermaid.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.mermaid.m_21573_().m_26571_()) {
                    this.mermaid.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.mermaid.m_20185_();
                double d1 = this.f_24976_ - this.mermaid.m_20186_();
                double d2 = this.f_24977_ - this.mermaid.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.mermaid.m_146922_(this.m_24991_(this.mermaid.m_146908_(), f, 90.0f));
                this.mermaid.f_20883_ = this.mermaid.m_146908_();
                float f1 = (float)(this.f_24978_ * this.mermaid.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.mermaid.m_6113_(), (float)f1);
                this.mermaid.m_7910_(f2);
                this.mermaid.m_20256_(this.mermaid.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.mermaid.f_19861_) {
                    this.mermaid.m_20256_(this.mermaid.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

