/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Minotaur
extends AbstractGaiaEntity
implements PowerableMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Minotaur.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.3, true);
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;

    public Minotaur(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 40;
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth3()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage3()).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22282_, 0.2).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 5.0);
    }

    @Override
    public int getGaiaLevel() {
        return 3;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
        if (state == 0) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)GaiaRegistry.MINOTAUR_HAMMER.get()));
        } else {
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense3();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (this.m_7090_()) {
            return !(source instanceof IndirectEntityDamageSource) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7090_() {
        return this.m_21223_() < this.m_21233_() / 2.0f;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 20;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 30;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        Vec3 motion = this.m_20184_();
        if (!this.f_19861_ && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.f_19853_.f_46443_ && this.m_20159_()) {
            this.m_8127_();
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.nextInt(5) == 0 && !(blockstate = this.f_19853_.m_8055_(pos = new BlockPos(i = Mth.m_14107_((double)this.m_20185_()), j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f)), k = Mth.m_14107_((double)this.m_20189_())))).m_60795_()) {
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.nextFloat() - 0.5), 0.5, ((double)this.f_19796_.nextFloat() - 0.5) * 4.0);
        }
        if (this.m_21223_() <= this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.buffEffect == 0) {
            this.setGoals(1);
            this.setAnimationState(1);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.m_21223_() > this.m_21233_() * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setGoals(0);
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        if (this.m_21224_()) {
            for (i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_8107_();
        }
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        this.setGoals(0);
    }

    private void setBuff() {
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 0));
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.MINOTAUR_HAMMER.get()));
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.f_42463_);
        this.m_8061_(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.m_41663_(Enchantments.f_44973_, 2);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        this.setCombatTask();
        return data;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.MINOTAUR.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.MINOTAUR.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.MINOTAUR.getDeath();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(GaiaRegistry.MINOTAUR.getStep(), 0.15f, 1.0f);
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkMinotaurSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Minotaur.checkDaysPassed(levelAccessor) && Minotaur.checkAboveSeaLevel(levelAccessor, pos) && Minotaur.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

