/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Naga
extends AbstractGaiaEntity
implements IDayMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Naga.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;
    private byte inWaterTimer;

    public Naga(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.m_21441_(BlockPathTypes.WATER, 8.0f);
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
        this.inWaterTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth2()).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage2()).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (this.hasShield()) {
            return !(source.m_7640_() instanceof AbstractArrow) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effectTime * 20, 0));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 2));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_20069_()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)8);
                this.m_5634_(this.m_21233_() * 0.1f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.m_21223_() <= this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.buffEffect == 0) {
            this.setGoals(1);
            this.setAnimationState(1);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.m_21223_() > this.m_21233_() * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setGoals(0);
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setBuff() {
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0));
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        }
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
        this.m_6850_(instance);
        ItemStack shield = new ItemStack((ItemLike)GaiaRegistry.GOLD_SHIELD.get());
        this.m_8061_(EquipmentSlot.OFFHAND, shield);
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.f_42463_);
        this.m_8061_(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.m_41663_(Enchantments.f_44973_, 3);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.setGoals(0);
        this.m_6851_(difficultyInstance);
        return data;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AnimationState", this.getAnimationState());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("AnimationState")) {
            int state = tag.m_128451_("AnimationState");
            this.setAnimationState(state);
        }
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.NAGA.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.NAGA.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.NAGA.getDeath();
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkNagaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Naga.checkDaysPassed(levelAccessor) && Naga.checkDaytime(levelAccessor) && Naga.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Naga.checkAboveSeaLevel(levelAccessor, pos) && Naga.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

