/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.Dwarf;
import gaia.entity.goal.MobAttackGoal;
import gaia.item.weapon.MagicStaffItem;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class Orc
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Orc.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private int buffEffect = 0;
    private boolean animationPlay = false;
    private int animationTimer = 0;
    private int switchHealth = 0;

    public Orc(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Dwarf.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.m_21206_().m_41619_() && this.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            return !(source.m_7640_() instanceof AbstractArrow) && super.m_6469_(source, input);
        }
        return super.m_6469_(source, input);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    @Override
    public void m_8107_() {
        if (this.getVariant() == 0) {
            if (this.m_21223_() <= this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.buffEffect == 0) {
                this.setGoals(2);
                this.setAnimationState(2);
                this.buffEffect = 1;
                this.animationPlay = true;
            }
            if (this.m_21223_() > this.m_21233_() * 0.25f && this.buffEffect == 1) {
                this.buffEffect = 0;
                this.animationPlay = false;
                this.animationTimer = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 15) {
                    ++this.animationTimer;
                } else {
                    this.setBuff();
                    this.setGoals(1);
                    this.setAnimationState(0);
                    this.animationPlay = false;
                }
            }
        } else if (this.getVariant() == 1) {
            this.beaconMonster(6, entity -> {
                if (entity instanceof Orc) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 300, 1, true, true));
                }
            });
            if (this.m_21223_() < this.m_21233_() * 0.5f && this.switchHealth == 0) {
                this.setGoals(1);
                this.switchHealth = 1;
            }
            if (this.m_21223_() > this.m_21233_() * 0.5f && this.switchHealth == 1) {
                this.setGoals(0);
                this.switchHealth = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 30) {
                    ++this.animationTimer;
                } else {
                    this.setAnimationState(0);
                    this.animationPlay = false;
                }
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
            this.f_21345_.m_25352_(2, (Goal)this.collideAttackGoal);
        } else if (id == 2) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
            this.f_21345_.m_25352_(2, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setBuff() {
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0));
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.m_8061_(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.collideAttackGoal);
        this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
        if (this.m_21205_().m_41720_() instanceof MagicStaffItem) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    protected void m_6851_(DifficultyInstance instance) {
        block0 : switch (this.getVariant()) {
            case 0: {
                switch (this.f_19796_.nextInt(2)) {
                    case 0: {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
                        break;
                    }
                    case 1: {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
                    }
                }
                break;
            }
            case 1: {
                switch (this.f_19796_.nextInt(2)) {
                    case 0: {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42423_));
                        break block0;
                    }
                    case 1: {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42428_));
                    }
                }
            }
        }
        ItemStack itemstack = this.m_21205_();
        ItemStack shield = ItemStack.f_41583_;
        ItemStack armor_leggings = ItemStack.f_41583_;
        ItemStack armor_chestplate = ItemStack.f_41583_;
        switch (this.getVariant()) {
            case 0: {
                if (itemstack.m_41720_() == Items.f_42428_) {
                    armor_leggings = new ItemStack((ItemLike)Items.f_42462_);
                }
                if (itemstack.m_41720_() != Items.f_42386_) break;
                armor_leggings = new ItemStack((ItemLike)Items.f_42462_);
                armor_chestplate = new ItemStack((ItemLike)Items.f_42408_);
                break;
            }
            case 1: {
                if (itemstack.m_41720_() == Items.f_42423_) {
                    shield = new ItemStack((ItemLike)GaiaRegistry.STONE_SHIELD.get());
                    armor_leggings = new ItemStack((ItemLike)Items.f_42462_);
                    armor_chestplate = new ItemStack((ItemLike)Items.f_42408_);
                }
                if (itemstack.m_41720_() != Items.f_42428_) break;
                shield = new ItemStack((ItemLike)GaiaRegistry.IRON_SHIELD.get());
                armor_leggings = new ItemStack((ItemLike)Items.f_42462_);
                armor_chestplate = new ItemStack((ItemLike)Items.f_42469_);
            }
        }
        this.m_8061_(EquipmentSlot.OFFHAND, shield);
        this.m_8061_(EquipmentSlot.LEGS, armor_leggings);
        this.m_8061_(EquipmentSlot.CHEST, armor_chestplate);
        this.setCanBreakDoors(true);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.nextInt(4) == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.MAGIC_STAFF.get()));
            this.setVariant(2);
        } else {
            switch (this.f_19796_.nextInt(2)) {
                case 0: {
                    this.setVariant(0);
                    break;
                }
                case 1: {
                    this.setVariant(1);
                }
            }
        }
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        this.setCombatTask();
        return data;
    }

    public void setCanBreakDoors(boolean enabled) {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(enabled);
        if (enabled) {
            this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.ORC.getEntityType();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.ORC.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.ORC.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.ORC.getDeath();
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkOrcSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Orc.checkDaysPassed(levelAccessor) && Orc.checkAboveSeaLevel(levelAccessor, pos) && Orc.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

