/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Shaman
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(Shaman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth;
    private int spawn;
    private int spawnTimer;
    private boolean animationPlay;
    private int animationTimer;

    public Shaman(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.switchHealth = 0;
        this.spawn = 0;
        this.spawnTimer = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth2()).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage2()).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        this.beaconMonster(6, entity -> {
            if (entity instanceof Zombie || entity instanceof Skeleton) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1, true, true));
            }
        });
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.switchHealth == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.m_21223_() > this.m_21233_() * 0.75f && this.switchHealth == 1) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.ZOMBIE_STAFF.get(), 1));
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.m_21223_() < this.m_21233_() * 0.75f && this.m_21223_() > 0.0f && this.spawn == 0) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.f_19853_.m_7605_((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.m_21223_() < this.m_21233_() * 0.25f && this.m_21223_() > 0.0f && this.spawn == 1) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.f_19853_.m_7605_((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setCombatTask() {
        if (this.m_21205_().m_150930_((Item)GaiaRegistry.ZOMBIE_STAFF.get())) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    private void setSpawn(int id) {
        if (!this.f_19853_.f_46443_) {
            BlockPos blockpos = this.m_142538_().m_142082_(-1 + this.f_19796_.nextInt(3), 1, -1 + this.f_19796_.nextInt(3));
            if (id == 0) {
                Zombie summon = (Zombie)EntityType.f_20501_.m_20615_(this.f_19853_);
                summon.m_20035_(blockpos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                summon.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_BOLT.get()));
                summon.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.FEET, 0.0f);
                summon.m_21409_(EquipmentSlot.LEGS, 0.0f);
                summon.m_21409_(EquipmentSlot.CHEST, 0.0f);
                summon.m_21409_(EquipmentSlot.HEAD, 0.0f);
                this.f_19853_.m_7967_((Entity)summon);
            }
        }
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.SHAMAN.getEntityType();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.potion(target, (LivingEntity)this, distanceFactor, Potions.f_43584_);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    protected void m_6851_(DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.ZOMBIE_STAFF.get()));
        this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43584_));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.m_6851_(difficultyInstance);
        this.m_6850_(difficultyInstance);
        this.setCombatTask();
        return data;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    protected float m_6515_(DamageSource damageSource, float damage) {
        damage = super.m_6515_(damageSource, damage);
        if (damageSource.m_7639_() == this) {
            damage = 0.0f;
        }
        if (damageSource.m_19387_()) {
            damage *= 0.15f;
        }
        return damage;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AnimationState", this.getAnimationState());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("AnimationState")) {
            int state = tag.m_128451_("AnimationState");
            this.setAnimationState(state);
        }
        this.setCombatTask();
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.SHAMAN.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.SHAMAN.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.SHAMAN.getDeath();
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkShamanSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Shaman.checkDaysPassed(levelAccessor) && Shaman.checkAboveSeaLevel(levelAccessor, pos) && Shaman.m_33017_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }
}

