/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Toad
extends AbstractGaiaEntity
implements IDayMob {
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("C1A38308-7270-476A-BAA1-3A906F5DCC88");
    private static final AttributeModifier KNOCKBACK_MODIFIER = new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Knockback boost", 2.0, AttributeModifier.Operation.ADDITION);
    private byte inWaterTimer;

    public Toad(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.inWaterTimer = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new LeapAttack(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)SharedEntityData.getMaxHealth1()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, (double)SharedEntityData.getAttackDamage1()).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                if (this.inWaterTimer <= 100) {
                    this.inWaterTimer = (byte)(this.inWaterTimer + 1);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)8);
                    this.m_5634_(this.m_21233_() * 0.1f);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                    this.inWaterTimer = 0;
                }
            }
            if (((Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_()).m_47505_(this.m_142538_()) > 1.0f) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
            }
        }
        super.m_8107_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22282_);
        attributeinstance.m_22130_(KNOCKBACK_MODIFIER);
        attributeinstance.m_22118_(KNOCKBACK_MODIFIER);
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.f_42463_);
        this.m_8061_(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.m_41663_(Enchantments.f_44973_, 2);
        return data;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.TOAD.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.TOAD.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.TOAD.getDeath();
    }

    public int m_5792_() {
        return 2;
    }

    protected int m_6101_() {
        return 10;
    }

    public static boolean checkToadSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return Toad.checkDaysPassed(levelAccessor) && Toad.checkDaytime(levelAccessor) && Toad.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Toad.checkAboveSeaLevel(levelAccessor, pos) && Toad.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }

    static class LeapAttack
    extends MobAttackGoal {
        public LeapAttack(Toad toad) {
            super((PathfinderMob)toad, 1.25, true);
        }

        protected double m_6639_(LivingEntity livingEntity) {
            return 4.0 + (double)livingEntity.m_20205_();
        }
    }
}

