/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class PoisonProjectile
extends SmallFireball {
    public PoisonProjectile(EntityType<? extends SmallFireball> entityType, Level level) {
        super(entityType, level);
    }

    public PoisonProjectile(Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.MAGIC.get()), level);
    }

    public PoisonProjectile(Level level, LivingEntity livingEntity, double accelX, double accelY, double accelZ) {
        super(level, livingEntity, accelX, accelY, accelZ);
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.m_37018_();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_POISON.get()) : itemstack;
    }

    public PoisonProjectile(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.POISON.get()), level);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)GaiaRegistry.POISON.get();
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123810_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 60) {
            this.m_146870_();
        }
    }

    protected float m_6884_() {
        return this.m_20147_() ? 0.73f : super.m_6884_();
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_8060_(BlockHitResult hitResult) {
    }

    protected void m_5790_(EntityHitResult entityResult) {
        Entity owner;
        if (!this.f_19853_.f_46443_ && (owner = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity ownerEntity = (LivingEntity)owner;
            Entity entity = entityResult.m_82443_();
            entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)ownerEntity), (float)SharedEntityData.getAttackDamage2() / 2.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, effectTime * 20, 1));
                }
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }
}

