/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaDataSerializers;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomMagicProjectile
extends SmallFireball {
    private static final EntityDataAccessor<ResourceLocation> EFFECT_LOCATION = SynchedEntityData.m_135353_(RandomMagicProjectile.class, GaiaDataSerializers.RESOURCE_LOCATION);

    public RandomMagicProjectile(EntityType<? extends SmallFireball> entityType, Level level) {
        super(entityType, level);
    }

    public RandomMagicProjectile(Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.RANDOM_MAGIC.get()), level);
    }

    public RandomMagicProjectile(Level level, LivingEntity livingEntity, double accelX, double accelY, double accelZ) {
        super(level, livingEntity, accelX, accelY, accelZ);
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.m_37018_();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_RANDOM_MAGIC.get()) : itemstack;
    }

    public RandomMagicProjectile(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends SmallFireball>)((EntityType)GaiaRegistry.RANDOM_MAGIC.get()), level);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)GaiaRegistry.RANDOM_MAGIC.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EFFECT_LOCATION, (Object)MobEffects.f_19597_.getRegistryName());
    }

    public ResourceLocation getEffectLocation() {
        return (ResourceLocation)this.f_19804_.m_135370_(EFFECT_LOCATION);
    }

    public MobEffect getEffect() {
        return this.getEffectLocation() == null ? null : (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.getEffectLocation());
    }

    public void setEffectLocation(ResourceLocation effectLocation) {
        this.f_19804_.m_135381_(EFFECT_LOCATION, (Object)effectLocation);
    }

    public void setEffect(MobEffect effect) {
        this.setEffectLocation(effect.getRegistryName());
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123810_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 60) {
            this.m_146870_();
        }
    }

    protected float m_6884_() {
        return this.m_20147_() ? 0.73f : super.m_6884_();
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("EffectLocation", this.getEffectLocation() == null ? "" : this.getEffectLocation().toString());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("EffectLocation")) {
            String effect = tag.m_128461_("EffectLocation");
            this.setEffectLocation(effect.isEmpty() ? null : ResourceLocation.m_135820_((String)effect));
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_8060_(BlockHitResult hitResult) {
    }

    protected void m_5790_(EntityHitResult entityResult) {
        Entity owner;
        if (!this.f_19853_.f_46443_ && (owner = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity ownerEntity = (LivingEntity)owner;
            Entity entity = entityResult.m_82443_();
            entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)ownerEntity), (float)SharedEntityData.getAttackDamage2() / 2.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int effectTime = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(this.getEffect(), effectTime * 20, 1));
                }
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }
}

