/*
 * Decompiled with CFR 0.152.
 */
package gaia.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class LootableItem
extends Item {
    private final ResourceLocation lootTable;
    private final Supplier<SoundEvent> openSoundSupplier;

    public LootableItem(Item.Properties properties, ResourceLocation lootTable, Supplier<SoundEvent> openSoundSupplier) {
        super(properties);
        this.lootTable = lootTable;
        this.openSoundSupplier = openSoundSupplier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_5496_(this.openSoundSupplier.get(), 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        if (!level.f_46443_) {
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level);
            LootTable lootTable = level.m_142572_().m_129898_().m_79217_(this.lootTable);
            builder.m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
            if (player != null) {
                builder.m_78963_(player.m_36336_());
            }
            List lootStacks = lootTable.m_79129_(builder.m_78975_(LootContextParamSets.f_81411_));
            for (ItemStack lootStack : lootStacks) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)lootStack);
            }
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)new TranslatableComponent("text.grimoireofgaia.right_click_use"));
    }
}

