/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.fuel;

import gaia.item.fuel.FuelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class FireshardItem
extends FuelItem {
    public FireshardItem(Item.Properties properties) {
        super(properties, 20000);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult blockHitResult = FireshardItem.getPlayerPOVCollisionHitResult(level, player, ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos relativePos = blockpos.m_142300_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(relativePos, direction, itemstack)) {
            BlockPos relativePos2;
            BlockState state = level.m_8055_(blockpos);
            BlockPos blockPos = relativePos2 = this.canBlockContainFluid(level, blockpos, state) ? blockpos : relativePos;
            if (level.m_7731_(relativePos2, Fluids.f_76195_.m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
                level.m_5594_(player, relativePos2, SoundEvents.f_11922_, SoundSource.BLOCKS, 0.4f, 0.8f);
                level.m_142346_((Entity)player, GameEvent.f_157769_, relativePos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, relativePos2, itemstack);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public static BlockHitResult getPlayerPOVCollisionHitResult(Level level, Player player, ClipContext.Fluid fluid) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, fluid, (Entity)player));
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, (Fluid)Fluids.f_76195_);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)new TranslatableComponent("text.grimoireofgaia.fireshard.desc").m_130940_(ChatFormatting.ITALIC));
    }
}

