/*
 * Decompiled with CFR 0.152.
 */
package gaia.item.weapon;

import gaia.registry.GaiaRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeI18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummonStaffItem
extends Item {
    private final Supplier<EntityType<? extends Mob>> typeSupplier;
    private final Supplier<Ingredient> repairIngredient;

    public SummonStaffItem(Item.Properties properties, Supplier<EntityType<? extends Mob>> typeSupplier, @NotNull Supplier<Ingredient> repairIngredient) {
        super(properties);
        this.typeSupplier = typeSupplier;
        this.repairIngredient = repairIngredient;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairStack) {
        return this.repairIngredient.get().test(repairStack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        super.m_5551_(stack, level, livingEntity, timeLeft);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            if (!level.f_46443_) {
                BlockPos spawnPos = player.m_146901_().m_142300_(player.m_6350_());
                Mob summon = (Mob)this.typeSupplier.get().m_20615_(level);
                summon.m_20035_(spawnPos, 0.0f, 0.0f);
                summon.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(spawnPos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                summon.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_BOLT.get()));
                summon.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                summon.m_21409_(EquipmentSlot.FEET, 0.0f);
                summon.m_21409_(EquipmentSlot.LEGS, 0.0f);
                summon.m_21409_(EquipmentSlot.CHEST, 0.0f);
                summon.m_21409_(EquipmentSlot.HEAD, 0.0f);
                CompoundTag tag = summon.getPersistentData();
                tag.m_128379_("grimoireofgaia_staff_summoned", true);
                tag.m_128362_("grimoireofgaia_staff_summoner", livingEntity.m_142081_());
                summon.f_21346_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof NearestAttackableTargetGoal);
                summon.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(summon, Monster.class, true, living -> {
                    NeutralMob neutralMob;
                    return !tag.m_128441_("grimoireofgaia_staff_summoned") && (living instanceof Monster && !(living instanceof NeutralMob) || living instanceof NeutralMob && (neutralMob = (NeutralMob)living).m_6120_().equals(livingEntity.m_142081_()));
                }));
                level.m_7967_((Entity)summon);
            }
            player.m_5496_(SoundEvents.f_11752_, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        } else {
            stack.m_41774_(1);
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)new TranslatableComponent("text.grimoireofgaia.summoning_staff.desc", new Object[]{ForgeI18n.getPattern((String)this.typeSupplier.get().m_20675_())}).m_130940_(ChatFormatting.GRAY));
    }

    public int m_8105_(ItemStack stack) {
        return 30;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44962_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

