/*
 * Decompiled with CFR 0.152.
 */
package gaia.util;

import gaia.config.GaiaConfig;
import gaia.entity.projectile.BombProjectile;
import gaia.entity.projectile.BubbleProjectile;
import gaia.entity.projectile.GaiaSmallFireball;
import gaia.entity.projectile.MagicProjectile;
import gaia.entity.projectile.PoisonProjectile;
import gaia.entity.projectile.RandomMagicProjectile;
import gaia.entity.projectile.WebProjectile;
import gaia.registry.GaiaSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class RangedUtil {
    public static void rangedAttack(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        ItemStack arrowStack = shooter.m_6298_(shooter.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof BowItem)));
        RangedUtil.rangedAttack(target, shooter, distanceFactor, arrowStack);
    }

    public static void rangedAttack(LivingEntity target, LivingEntity shooter, float distanceFactor, ItemStack arrowStack) {
        AbstractArrow abstractarrow = RangedUtil.getArrow(shooter, arrowStack, distanceFactor);
        if (shooter.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)shooter.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = target.m_20189_() - shooter.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - shooter.f_19853_.m_46791_().m_19028_() * 4));
        abstractarrow.m_36781_((double)distanceFactor * 2.0 + shooter.m_21187_().nextGaussian() * 0.25 + (double)shooter.f_19853_.m_46791_().m_19028_() * 0.11);
        if (shooter.f_19853_.m_46791_() == Difficulty.HARD && ((Boolean)GaiaConfig.COMMON.baseDamageArchers.get()).booleanValue() && abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.m_36870_(new MobEffectInstance(MobEffects.f_19602_, 1, 0));
        }
        shooter.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        shooter.f_19853_.m_7967_((Entity)abstractarrow);
    }

    public static AbstractArrow getArrow(LivingEntity shooter, ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)shooter, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public static void fireball(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        GaiaSmallFireball smallFireball = new GaiaSmallFireball(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        smallFireball.m_6034_(smallFireball.m_20185_(), shooter.m_20227_(0.5) + 0.5, smallFireball.m_20189_());
        shooter.f_19853_.m_7967_((Entity)smallFireball);
    }

    public static void potion(LivingEntity target, LivingEntity shooter, float distanceFactor, Potion potion) {
        Vec3 vec3 = shooter.m_20184_();
        double d0 = target.m_20186_() + (double)target.m_20192_() - (double)1.1f;
        double d1 = target.m_20185_() + vec3.f_82479_ - shooter.m_20185_();
        double d2 = d0 - shooter.m_20186_();
        double d3 = target.m_20189_() + vec3.f_82481_ - shooter.m_20189_();
        float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3)));
        ThrownPotion thrownpotion = new ThrownPotion(shooter.f_19853_, shooter);
        thrownpotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
        thrownpotion.m_146926_(thrownpotion.m_146909_() + 20.0f);
        thrownpotion.m_6686_(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        shooter.f_19853_.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12553_, shooter.m_5720_(), 1.0f, 0.8f + shooter.m_21187_().nextFloat() * 0.4f);
        shooter.f_19853_.m_7967_((Entity)thrownpotion);
    }

    public static void magic(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        MagicProjectile magic = new MagicProjectile(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        magic.m_6034_(magic.m_20185_(), shooter.m_20227_(0.5) + 0.5, magic.m_20189_());
        shooter.f_19853_.m_7967_((Entity)magic);
    }

    public static void magicRandom(LivingEntity target, LivingEntity shooter, float distanceFactor, double yOffset, MobEffect mobEffect) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        RandomMagicProjectile magic = new RandomMagicProjectile(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        magic.m_6034_(magic.m_20185_(), shooter.m_20227_(0.5) + 0.5 + yOffset, magic.m_20189_());
        magic.setEffect(mobEffect);
        shooter.f_19853_.m_7967_((Entity)magic);
    }

    public static void web(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        WebProjectile web = new WebProjectile(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        web.m_6034_(web.m_20185_(), shooter.m_20227_(0.5) + 0.5, web.m_20189_());
        shooter.f_19853_.m_7967_((Entity)web);
    }

    public static void bubble(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        BubbleProjectile bubble = new BubbleProjectile(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        bubble.m_6034_(bubble.m_20185_(), shooter.m_20227_(0.5) + 0.5, bubble.m_20189_());
        shooter.f_19853_.m_7967_((Entity)bubble);
    }

    public static void poison(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        double f1 = (double)Mth.m_14116_((float)distanceFactor) * 0.5;
        PoisonProjectile poison = new PoisonProjectile(shooter.f_19853_, shooter, d0 + shooter.m_21187_().nextGaussian() * f1, d1, d2 + shooter.m_21187_().nextGaussian() * f1);
        poison.m_6034_(poison.m_20185_(), shooter.m_20227_(0.5) + 0.5, poison.m_20189_());
        shooter.f_19853_.m_7967_((Entity)poison);
    }

    public static void bomb(LivingEntity target, LivingEntity shooter, float distanceFactor) {
        shooter.m_5496_((SoundEvent)GaiaSounds.GAIA_SHOOT.get(), 1.0f, 1.0f / (shooter.m_21187_().nextFloat() * 0.4f + 0.8f));
        BombProjectile bomb = new BombProjectile(shooter.f_19853_, shooter);
        double d0 = target.m_20188_() - (double)1.1f;
        double d1 = target.m_20185_() - shooter.m_20185_();
        double d2 = d0 - bomb.m_20186_();
        double d3 = target.m_20189_() - shooter.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        bomb.m_6686_(d1, d2 + d4, d3, 0.75f, 8.0f);
        shooter.f_19853_.m_7967_((Entity)bomb);
    }
}

