/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.commands;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.lib.PlayerSlot;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KitsCommand {
    private static Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"csg_kits").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"kit-name", (ArgumentType)StringArgumentType.string()).executes(ctx -> KitsCommand.add((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name")))))).then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"kit-name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(DataManager.kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitsCommand.give((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name"), ((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> KitsCommand.give((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name"), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"kit-name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(DataManager.kits.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> KitsCommand.remove((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"kit-name")))))).then(Commands.m_82127_((String)"list").executes(KitsCommand::list)));
    }

    private static int add(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        ItemStack stack;
        int i;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        HashMap<PlayerSlot, CompoundTag> newKit = new HashMap<PlayerSlot, CompoundTag>();
        for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN), stack.serializeNBT());
        }
        for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (stack.m_41619_()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.ARMOR), stack.serializeNBT());
        }
        for (i = 0; i < player.m_150109_().f_35976_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35976_.get(i);
            if (stack.m_41619_()) continue;
            newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND), stack.serializeNBT());
        }
        DataManager.kits.put(name, newKit);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent(e.getMessage() + " [See console for stacktrace]"));
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Your current inventory has been saved to kit " + name).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int give(CommandContext<CommandSourceStack> ctx, String name, ServerPlayer player) {
        if (!DataManager.kits.containsKey(name)) {
            throw new CommandRuntimeException((Component)new TextComponent("The specified kit does not exist!"));
        }
        DataManager.givePlayerKit((Player)player, name);
        return 0;
    }

    private static int remove(CommandContext<CommandSourceStack> ctx, String name) {
        if (!DataManager.kits.containsKey(name)) {
            throw new CommandRuntimeException((Component)new TextComponent("The specified kit does not exist!"));
        }
        DataManager.kits.remove(name);
        try {
            DataManager.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Something when wrong while saving inventory!");
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent(e.getMessage() + " [See console for stacktrace]"));
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Kit removed successfully!").m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("### Kits ###").m_130940_(ChatFormatting.GOLD), Util.f_137441_);
        for (String name : DataManager.kits.keySet()) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent(name).m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        }
        return 0;
    }
}

