/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.lib;

import io.netty.buffer.ByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerSlot {
    private static Logger LOGGER = LogManager.getLogger();
    private int slot;
    private EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public String toString() {
        return this.category.getIndex() + ":" + this.slot;
    }

    public static PlayerSlot fromString(String slot) {
        try {
            return new PlayerSlot(Integer.parseInt(slot.substring(slot.indexOf(":") + 1)), EnumInvCategory.fromIndex(Integer.parseInt(slot.substring(0, slot.indexOf(":")))));
        }
        catch (Exception e) {
            LOGGER.error("Error loading slot reference from string! - " + slot);
            LOGGER.error("Required format \"inventory:slot\" Where inventory ether 0 (main), 1 (Armor) or 2 (Off Hand) and slot is the index in that inventory.");
            e.printStackTrace();
            return new PlayerSlot(0, EnumInvCategory.MAIN);
        }
    }

    public void setStackInSlot(Player player, ItemStack stack) {
        if (this.category == EnumInvCategory.ARMOR) {
            if (this.slot < 0 || this.slot >= player.m_150109_().f_35975_.size()) {
                LOGGER.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + this.category + ", Stack: " + stack);
                return;
            }
            player.m_150109_().f_35975_.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.MAIN) {
            if (this.slot < 0 || this.slot >= player.m_150109_().f_35974_.size()) {
                LOGGER.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + this.category + ", Stack: " + stack);
                return;
            }
            player.m_150109_().f_35974_.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            if (this.slot < 0 || this.slot >= player.m_150109_().f_35976_.size()) {
                LOGGER.error("PlayerSlot: Could not insert into the specified slot because the specified slot dose not exist! Slot: " + this.slot + ", Inventory: " + this.category + ", Stack: " + stack);
                return;
            }
            player.m_150109_().f_35976_.set(this.slot, (Object)stack);
        }
    }

    public ItemStack getStackInSlot(Player player) {
        if (this.category == EnumInvCategory.ARMOR) {
            return (ItemStack)player.m_150109_().f_35975_.get(this.slot);
        }
        if (this.category == EnumInvCategory.MAIN) {
            return (ItemStack)player.m_150109_().f_35974_.get(this.slot);
        }
        if (this.category == EnumInvCategory.OFF_HAND) {
            return (ItemStack)player.m_150109_().f_35976_.get(this.slot);
        }
        LOGGER.error("PlayerSlot#getStackInSlot Invalid or null category! This should not be possible! {}}...", (Object)this.category);
        return ItemStack.f_41583_;
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2);

        private int index;
        private static EnumInvCategory[] indexMap;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 2 || index < 0) {
                LOGGER.error("PlayerSlot.EnumInvCategory#fromIndex Attempt to read invalid index! {}", (Object)index);
                return indexMap[0];
            }
            return indexMap[index];
        }

        static {
            indexMap = new EnumInvCategory[3];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
        }
    }
}

