/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.forge.datagen.lootmod;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PaucalAddItemModifier
extends LootModifier {
    private static final Gson GSON = Deserializers.m_78799_().create();
    private final Item addedItem;
    private final LootItemFunction[] funcs;

    public PaucalAddItemModifier(Item addedItem, LootItemFunction[] funcs, LootItemCondition[] conditions) {
        super(conditions);
        this.addedItem = addedItem;
        this.funcs = funcs;
    }

    public PaucalAddItemModifier(Item addedItem, int count, LootItemCondition[] conditions) {
        this(addedItem, new LootItemFunction[]{SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)).m_7453_()}, conditions);
    }

    public PaucalAddItemModifier(Item addedItem, NumberProvider count, LootItemCondition[] conditions) {
        this(addedItem, new LootItemFunction[]{SetItemCountFunction.m_165412_((NumberProvider)count).m_7453_()}, conditions);
    }

    public PaucalAddItemModifier(Item addedItem, LootItemCondition[] conditions) {
        this(addedItem, 1, conditions);
    }

    public PaucalAddItemModifier(Item addedItem, ResourceLocation target) {
        this(addedItem, 1, target);
    }

    public PaucalAddItemModifier(Item addedItem, int count, ResourceLocation target) {
        this(addedItem, (NumberProvider)ConstantValue.m_165692_((float)count), new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)target).m_6409_()});
    }

    public PaucalAddItemModifier(Item addedItem, NumberProvider count, ResourceLocation target) {
        this(addedItem, new LootItemFunction[]{SetItemCountFunction.m_165412_((NumberProvider)count).m_7453_()}, new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)target).m_6409_()});
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack out = new ItemStack((ItemLike)this.addedItem);
        for (LootItemFunction func : this.funcs) {
            out = (ItemStack)func.apply((Object)out, (Object)context);
        }
        generatedLoot.add(out);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<PaucalAddItemModifier> {
        public PaucalAddItemModifier read(ResourceLocation location, JsonObject json, LootItemCondition[] conditions) {
            Item addedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item")));
            JsonElement functionElements = json.get("functions");
            LootItemFunction[] functions = (LootItemFunction[])GSON.fromJson(functionElements, LootItemFunction[].class);
            return new PaucalAddItemModifier(addedItem, functions, conditions);
        }

        public JsonObject write(PaucalAddItemModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", instance.addedItem.getRegistryName().toString());
            JsonElement functions = GSON.toJsonTree((Object)instance.funcs);
            json.add("functions", functions);
            return json;
        }
    }
}

