/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.advancement;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.api.contrib.ContributorType;
import at.petrak.paucal.common.Contributors;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class BeContributorTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("paucal", "login_as_patron");
    private static final String TAG_PATRON_LEVEL = "patron_level";
    private static final String TAG_IS_DEV = "is_dev";
    private static final String TAG_IS_COOL = "is_cool";

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext ctx) {
        Boolean isDev = json.has(TAG_IS_DEV) ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)json, (String)TAG_IS_DEV)) : null;
        Boolean isCool = json.has(TAG_IS_COOL) ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)json, (String)TAG_IS_COOL)) : null;
        return new Instance(predicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_PATRON_LEVEL)), isDev, isCool);
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player) {
        super.m_66234_(player, inst -> {
            UUID uuid = player.m_142081_();
            Contributor profile = Contributors.getContributor(uuid);
            if (profile == null) {
                return false;
            }
            ContributorType type = profile.getContributorType();
            return !(!inst.patronLevel.m_55390_(type.level()) || inst.isDev != null && inst.isDev.booleanValue() != type.isDev() || inst.isCool != null && inst.isCool.booleanValue() != type.isCool());
        });
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints patronLevel;
        @Nullable
        protected final Boolean isDev;
        @Nullable
        protected final Boolean isCool;

        public Instance(EntityPredicate.Composite predicate, MinMaxBounds.Ints patronLevel, @Nullable Boolean isDev, @Nullable Boolean isCool) {
            super(ID, predicate);
            this.patronLevel = patronLevel;
            this.isDev = isDev;
            this.isCool = isCool;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject json = super.m_7683_(ctx);
            if (!this.patronLevel.m_55327_()) {
                json.add(BeContributorTrigger.TAG_PATRON_LEVEL, this.patronLevel.m_55328_());
            }
            if (this.isDev != null) {
                json.addProperty(BeContributorTrigger.TAG_IS_DEV, this.isDev);
            }
            if (this.isCool != null) {
                json.addProperty(BeContributorTrigger.TAG_IS_COOL, this.isCool);
            }
            return json;
        }
    }
}

