/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat;

import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.xplat.Platform;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface IXplatAbstractions {
    public static final IXplatAbstractions INSTANCE = IXplatAbstractions.find();

    public Platform platform();

    @Nullable
    public SoundEvent getSoundByID(ResourceLocation var1);

    public ResourceLocation getID(Block var1);

    public ResourceLocation getID(Item var1);

    public void saveRecipeAdvancement(DataGenerator var1, HashCache var2, JsonObject var3, Path var4);

    default public void init() {
        PaucalAPI.LOGGER.info("Hello PAUCAL! This is {}!", (Object)this.platform());
    }

    private static IXplatAbstractions find() {
        List<ServiceLoader.Provider<IXplatAbstractions>> providers = ServiceLoader.load(IXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("There should be exactly one IXplatAbstractions implementation on the classpath. Found: " + names);
        }
        ServiceLoader.Provider<IXplatAbstractions> provider = providers.get(0);
        PaucalAPI.LOGGER.debug("Instantiating xplat impl: " + provider.type().getName());
        return provider.get();
    }
}

