/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import net.glad0s.bobberdetector.block.ModBlocks;
import net.glad0s.bobberdetector.block.TileEntityInit;
import net.glad0s.bobberdetector.block.entity.BobberDetectorTileEntity;
import net.glad0s.bobberdetector.item.ModItems;
import net.glad0s.bobberdetector.register.ModPonders;
import net.glad0s.bobberdetector.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="bobberdetector")
public class BobberDetector {
    public static final String MOD_ID = "bobberdetector";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"bobberdetector");

    public BobberDetector() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRATE.registerEventListeners(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        TileEntityInit.TILE_ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(ModPonders::register);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock e) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockEntity entity = level.m_7702_(e.getTarget().m_82425_());
            if (entity instanceof BobberDetectorTileEntity) {
                e.getPoseStack().m_85836_();
                Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                AABB area = ((BobberDetectorTileEntity)entity).getAffectedArea();
                RenderUtils.renderShape(e.getPoseStack(), Shapes.m_83064_((AABB)area), 1.0f, 1.0f, 1.0f, 0.7f, false);
                e.getPoseStack().m_85849_();
            }
        }
    }

    @Mod.EventBusSubscriber(modid="bobberdetector", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final TagKey<EntityType<?>> BobberTag = ForgeRegistries.ENTITIES.tags().createTagKey(new ResourceLocation("forge", "bobber"));
    }
}

