/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.fluid_pipe.forge;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ExpandedFluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.m_6299_(RenderTypes.getFluid());
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, float centerOffset, boolean inbound, MultiBufferSource buffer, PoseStack ms, int light) {
        ExpandedFluidRenderer.renderFluidStream(fluidStack, direction, radius, progress, centerOffset, inbound, ExpandedFluidRenderer.getFluidBuilder(buffer), ms, light);
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, float centerOffset, boolean inbound, VertexConsumer builder, PoseStack ms, int light) {
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes fluidAttributes = fluid.getAttributes();
        Function spriteAtlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite flowTexture = (TextureAtlasSprite)spriteAtlas.apply(fluidAttributes.getFlowingTexture(fluidStack));
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)spriteAtlas.apply(fluidAttributes.getStillTexture(fluidStack));
        int color = fluidAttributes.getColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLuminosity(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.m_122424_();
        }
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ms.m_85836_();
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)direction))).rotateX(direction == Direction.UP ? 180.0 : (direction == Direction.DOWN ? 0.0 : 270.0))).unCentre();
        ms.m_85837_(0.5, 0.0, 0.5);
        float h = radius;
        float hMin = -radius;
        float hMax = radius;
        float y = inbound ? 1.0f : 0.5f + centerOffset;
        float yMin = y - Mth.m_14036_((float)(progress * (0.5f + centerOffset)), (float)0.0f, (float)1.0f);
        float yMax = y;
        for (int i = 0; i < 4; ++i) {
            ms.m_85836_();
            FluidRenderer.renderFlowingTiledFace((Direction)Direction.SOUTH, (float)hMin, (float)yMin, (float)hMax, (float)yMax, (float)h, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)flowTexture);
            ms.m_85849_();
            msr.rotateY(90.0);
        }
        if (progress != 1.0f) {
            FluidRenderer.renderStillTiledFace((Direction)Direction.DOWN, (float)hMin, (float)hMin, (float)hMax, (float)hMax, (float)yMin, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)stillTexture);
        }
        ms.m_85849_();
    }
}

