/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.half_layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.OctahedralGroup;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatHalfLayerBlock
extends WaterloggedMultiStateCopycatBlock
implements ISpecialBlockItemRequirement {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final IntegerProperty POSITIVE_LAYERS = IntegerProperty.m_61631_((String)"positive_layers", (int)0, (int)8);
    public static final IntegerProperty NEGATIVE_LAYERS = IntegerProperty.m_61631_((String)"negative_layers", (int)0, (int)8);
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public CopycatHalfLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0)));
        this.shapesCache = this.m_152458_(CopycatHalfLayerBlock::calculateMultiFaceShape);
    }

    @Override
    public String defaultProperty() {
        return NEGATIVE_LAYERS.m_61708_();
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(2, 1, 1);
            case Direction.Axis.Y -> new Vec3i(1, 2, 1);
            case Direction.Axis.Z -> new Vec3i(1, 1, 2);
        };
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        if (property.equals(POSITIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)POSITIVE_LAYERS) > 0;
        }
        if (property.equals(NEGATIVE_LAYERS.m_61708_())) {
            return (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) > 0;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(POSITIVE_LAYERS.m_61708_(), NEGATIVE_LAYERS.m_61708_());
    }

    @Override
    public int getColorIndex(String property) {
        return property.equals(POSITIVE_LAYERS.m_61708_()) ? 1 : 0;
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        if (hitLocation.m_123304_((Direction.Axis)state.m_61143_(AXIS)) > 0) {
            return POSITIVE_LAYERS.m_61708_();
        }
        return NEGATIVE_LAYERS.m_61708_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (property.equals(POSITIVE_LAYERS.m_61708_())) {
                    yield new Vec3i(1, 0, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Y -> {
                if (property.equals(POSITIVE_LAYERS.m_61708_())) {
                    yield new Vec3i(0, 1, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Z -> property.equals(POSITIVE_LAYERS.m_61708_()) ? new Vec3i(0, 0, 1) : new Vec3i(0, 0, 0);
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            Vec3 clickPosition = context.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
            IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
            if ((Integer)state.m_61143_((Property)targetProp) < 8) {
                return (BlockState)state.m_61122_((Property)targetProp);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a step layer! Please file an issue if you see this.");
            return state;
        }
        Direction.Axis axis = context.m_8125_().m_122434_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
        return (BlockState)((BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(HALF, (Comparable)(clickPosition.f_82480_ > 0.5 ? Half.TOP : Half.BOTTOM))).m_61124_((Property)(axis.m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) > 0.5 ? POSITIVE_LAYERS : NEGATIVE_LAYERS), (Comparable)Integer.valueOf(1));
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        Direction clickFace = pUseContext.m_43719_();
        if (clickFace.m_122434_().m_122478_() && pState.m_61143_(HALF) == Half.TOP == (clickFace == Direction.UP)) {
            return false;
        }
        Vec3 clickPosition = pUseContext.m_43720_().m_82549_(Vec3.m_82528_((Vec3i)pUseContext.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pUseContext.m_8083_()));
        IntegerProperty targetProp = ((Direction.Axis)pState.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        return (Integer)pState.m_61143_((Property)targetProp) != 8;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)POSITIVE_LAYERS) + (Integer)state.m_61143_((Property)NEGATIVE_LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Vec3 clickPosition = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_(0.0625)).m_82546_(Vec3.m_82528_((Vec3i)pos));
        IntegerProperty targetProp = ((Direction.Axis)state.m_61143_(AXIS)).m_6150_(clickPosition.f_82479_, clickPosition.f_82480_, clickPosition.f_82481_) < 0.5 ? NEGATIVE_LAYERS : POSITIVE_LAYERS;
        if ((Integer)state.m_61143_((Property)targetProp) == 1) {
            this.onWrenched(state, context);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)Integer.valueOf(0))).m_61124_((Property)targetProp, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_142300_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)targetProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)targetProp) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ICopycatBlock.getRequiredItemsForLayer(state, POSITIVE_LAYERS).union(ICopycatBlock.getRequiredItemsForLayer(state, NEGATIVE_LAYERS));
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        return !toState.m_60713_((Block)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (reader instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledReader = (ScaledBlockAndTintGetter)reader;
            if (toState.m_60713_((Block)this)) {
                String toProperty = scaledReader.getPropertyForRender(toState, toPos);
                int fromLayers = (Integer)state.m_61143_((Property)(property.equals(POSITIVE_LAYERS.m_61708_()) ? POSITIVE_LAYERS : NEGATIVE_LAYERS));
                int toLayers = (Integer)toState.m_61143_((Property)(toProperty.equals(POSITIVE_LAYERS.m_61708_()) ? POSITIVE_LAYERS : NEGATIVE_LAYERS));
                return fromLayers == toLayers;
            }
        }
        return toState.m_60713_((Block)this);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            state = transform.mirror.m_54842_() == OctahedralGroup.INVERT_Y ? (BlockState)state.m_61122_(HALF) : state.m_60717_(transform.mirror.m_54846_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)))));
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == Direction.Axis.Y) {
                Function<Direction.Axis, Direction.Axis> swap = axis -> axis == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
                state = switch (transform.rotation) {
                    default -> throw new IncompatibleClassChangeError();
                    case Rotation.NONE -> state;
                    case Rotation.CLOCKWISE_90 -> {
                        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                        if (axis == Direction.Axis.X) {
                            yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                        }
                        yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
                    }
                    case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)state.m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
                    case Rotation.COUNTERCLOCKWISE_90 -> {
                        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
                        if (axis == Direction.Axis.Z) {
                            yield (BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis));
                        }
                        yield (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)swap.apply(axis))).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS)));
                    }
                };
            } else if (transform.rotation == Rotation.CLOCKWISE_180) {
                state = transform.rotationAxis != state.m_61143_(AXIS) ? (BlockState)((BlockState)((BlockState)state.m_61122_(HALF)).m_61124_((Property)POSITIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)NEGATIVE_LAYERS)))).m_61124_((Property)NEGATIVE_LAYERS, (Comparable)((Integer)state.m_61143_((Property)POSITIVE_LAYERS))) : (BlockState)state.m_61122_(HALF);
            }
        }
        return state;
    }

    @Override
    public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (transform.mirror != null && transform.mirror != Mirror.NONE && (transform.mirror.m_54842_() == OctahedralGroup.INVERT_Z && axis == Direction.Axis.Z || transform.mirror.m_54842_() == OctahedralGroup.INVERT_X && axis == Direction.Axis.X)) {
            be.getMaterialItemStorage().remapStorage(s -> s.equals(POSITIVE_LAYERS.m_61708_()) ? NEGATIVE_LAYERS.m_61708_() : POSITIVE_LAYERS.m_61708_());
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis.m_122478_()) {
                if (transform.rotation == Rotation.CLOCKWISE_90 && axis == Direction.Axis.X || transform.rotation == Rotation.CLOCKWISE_180 || transform.rotation == Rotation.COUNTERCLOCKWISE_90 && axis == Direction.Axis.Z) {
                    be.getMaterialItemStorage().remapStorage(s -> s.equals(POSITIVE_LAYERS.m_61708_()) ? NEGATIVE_LAYERS.m_61708_() : POSITIVE_LAYERS.m_61708_());
                }
            } else if (transform.rotation == Rotation.CLOCKWISE_180 && transform.rotationAxis != axis) {
                be.getMaterialItemStorage().remapStorage(s -> s.equals(POSITIVE_LAYERS.m_61708_()) ? NEGATIVE_LAYERS.m_61708_() : POSITIVE_LAYERS.m_61708_());
            }
        }
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{AXIS, HALF, POSITIVE_LAYERS, NEGATIVE_LAYERS}));
    }

    private static VoxelShape calculateMultiFaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)CCShapes.HALF_LAYER_BOTTOM.get(pState.m_61143_(AXIS)).get(pState.m_61143_(HALF)).get(pState.m_61143_((Property)NEGATIVE_LAYERS)).toShape(), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)CCShapes.HALF_LAYER_TOP.get(pState.m_61143_(AXIS)).get(pState.m_61143_(HALF)).get(pState.m_61143_((Property)POSITIVE_LAYERS)).toShape(), (BooleanOp)BooleanOp.f_82695_);
        return shape.m_83296_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        VoxelShape shapeOverride = IMultiStateCopycatBlock.blockShapeOverride(pState, pLevel, pPos, pContext);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return IMultiStateCopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }
}

