/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slice;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatSliceBlock
extends CCWaterloggedCopycatBlock
implements ISpecialBlockItemRequirement,
IStateType {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;

    public CopycatSliceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Half half = (Half)state.m_61143_(HALF);
            int layers = (Integer)state.m_61143_((Property)LAYERS);
            return toState.m_61143_((Property)FACING) != facing || toState.m_61143_(HALF) != half || (Integer)toState.m_61143_((Property)LAYERS) != layers;
        }
        return true;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        BlockPos diff = toPos.m_141950_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = BackportUtils.directionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_((Property)FACING) == facing && toState.m_61143_(HALF) == half && (Integer)toState.m_61143_((Property)LAYERS) == layers && face.m_122434_() == facing.m_122427_().m_122434_();
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return false;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> {
                if ((Integer)pState.m_61143_((Property)LAYERS) < 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            if ((Integer)state.m_61143_((Property)LAYERS) < 8) {
                return (BlockState)state.m_61122_((Property)LAYERS);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a slice! Please file an issue if you see this.");
            return state;
        }
        Direction facing = context.m_8125_();
        if (facing.m_122434_() == Direction.Axis.X) {
            if (facing.m_122421_() == Direction.AxisDirection.POSITIVE != context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_() > 0.5) {
                facing = facing.m_122424_();
            }
        } else if (facing.m_122421_() == Direction.AxisDirection.POSITIVE != context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_() > 0.5) {
            facing = facing.m_122424_();
        }
        stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)facing);
        Direction direction = context.m_43719_();
        if (direction == Direction.UP) {
            return stateForPlacement;
        }
        if (direction == Direction.DOWN || context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5) {
            return (BlockState)stateForPlacement.m_61124_(HALF, (Comparable)Half.TOP);
        }
        return stateForPlacement;
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if ((Integer)pState.m_61143_((Property)LAYERS) == 8) {
            return false;
        }
        Half half = (Half)pState.m_61143_(HALF);
        if (half == Half.TOP && pUseContext.m_43719_() == Direction.DOWN || half == Half.BOTTOM && pUseContext.m_43719_() == Direction.UP) {
            return true;
        }
        return pUseContext.m_43719_() == ((Direction)pState.m_61143_((Property)FACING)).m_122424_();
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_142300_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LAYERS) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ICopycatBlock.getRequiredItemsForLayer(state, LAYERS);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{HALF, FACING, LAYERS}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CCShapes.SLICE.get(pState.m_61143_((Property)FACING)).get(pState.m_61143_(HALF)).get(pState.m_61143_((Property)LAYERS)).toShape();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return BlockUtils.transformStepLikeHorizontal(state, transform, CCBlocks.COPYCAT_VERTICAL_SLICE.getDefaultState());
    }
}

